/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model;

import java.util.Optional;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.TransitEntity;
import org.opentripplanner.model.WgsCoordinate;

public class FlexStopLocation
extends TransitEntity
implements StopLocation {
    private static final long serialVersionUID = 1L;
    private String name;
    private String description;
    private Geometry geometry;
    private String zoneId;
    private String url;
    private Point centroid;

    public FlexStopLocation(FeedScopedId id) {
        super(id);
    }

    @Override
    public String getName() {
        return Optional.ofNullable(this.name).orElse(this.getId().toString());
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Geometry getGeometry() {
        return this.geometry;
    }

    public void setGeometry(Geometry geometry) {
        this.geometry = geometry;
        this.centroid = geometry.getCentroid();
    }

    @Override
    public WgsCoordinate getCoordinate() {
        return new WgsCoordinate(this.centroid.getY(), this.centroid.getX());
    }

    @Override
    public String getFirstZoneAsString() {
        return this.zoneId;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    @Override
    public boolean isPartOfStation() {
        return false;
    }

    @Override
    public boolean isPartOfSameStationAs(StopLocation alternativeStop) {
        return false;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

