/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model;

import java.util.HashSet;
import java.util.Set;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.Point;
import org.opentripplanner.common.geometry.GeometryUtils;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.FlexStopLocation;
import org.opentripplanner.model.Stop;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.TransitEntity;
import org.opentripplanner.model.WgsCoordinate;

public class FlexLocationGroup
extends TransitEntity
implements StopLocation {
    private static final long serialVersionUID = 1L;
    private String name;
    private final Set<StopLocation> stopLocations = new HashSet<StopLocation>();
    private GeometryCollection geometry = new GeometryCollection(null, GeometryUtils.getGeometryFactory());
    private Point centroid;

    public FlexLocationGroup(FeedScopedId id) {
        super(id);
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getUrl() {
        return null;
    }

    @Override
    public WgsCoordinate getCoordinate() {
        return new WgsCoordinate(this.centroid.getY(), this.centroid.getX());
    }

    @Override
    public String getFirstZoneAsString() {
        return null;
    }

    @Override
    public Geometry getGeometry() {
        return this.geometry;
    }

    @Override
    public boolean isPartOfStation() {
        return false;
    }

    @Override
    public boolean isPartOfSameStationAs(StopLocation alternativeStop) {
        return false;
    }

    public void addLocation(StopLocation location) {
        this.stopLocations.add(location);
        int numGeometries = this.geometry.getNumGeometries();
        Geometry[] newGeometries = new Geometry[numGeometries + 1];
        for (int i = 0; i < numGeometries; ++i) {
            newGeometries[i] = this.geometry.getGeometryN(i);
        }
        if (location instanceof Stop) {
            WgsCoordinate coordinate = location.getCoordinate();
            Envelope envelope = new Envelope(coordinate.asJtsCoordinate());
            double xscale = Math.cos(coordinate.latitude() * Math.PI / 180.0);
            envelope.expandBy(100.0 / xscale, 100.0);
            newGeometries[numGeometries] = GeometryUtils.getGeometryFactory().toGeometry(envelope);
        } else if (location instanceof FlexStopLocation) {
            newGeometries[numGeometries] = location.getGeometry();
        } else {
            throw new RuntimeException("Unknown location type");
        }
        this.geometry = new GeometryCollection(newGeometries, GeometryUtils.getGeometryFactory());
        this.centroid = this.geometry.getCentroid();
    }

    public Set<StopLocation> getLocations() {
        return this.stopLocations;
    }
}

