/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.opentripplanner.util.AssertUtils;

public final class FeedScopedId
implements Serializable,
Comparable<FeedScopedId> {
    private static final char ID_SEPARATOR = ':';
    private static final long serialVersionUID = 1L;
    private final String feedId;
    private final String id;

    public FeedScopedId(@NotNull String feedId, @NotNull String id) {
        AssertUtils.assertHasValue(feedId);
        AssertUtils.assertHasValue(id);
        this.feedId = feedId;
        this.id = id;
    }

    public String getFeedId() {
        return this.feedId;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public int compareTo(FeedScopedId o) {
        int c = this.feedId.compareTo(o.feedId);
        if (c == 0) {
            c = this.id.compareTo(o.id);
        }
        return c;
    }

    public String toString() {
        return FeedScopedId.concatenateId(this.feedId, this.id);
    }

    public int hashCode() {
        return this.feedId.hashCode() ^ this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FeedScopedId)) {
            return false;
        }
        FeedScopedId other = (FeedScopedId)obj;
        return this.feedId.equals(other.feedId) && this.id.equals(other.id);
    }

    public static FeedScopedId parseId(String value) throws IllegalArgumentException {
        if (value == null || value.isEmpty()) {
            return null;
        }
        int index = value.indexOf(58);
        if (index == -1) {
            throw new IllegalArgumentException("invalid feed-scoped-id: " + value);
        }
        return new FeedScopedId(value.substring(0, index), value.substring(index + 1));
    }

    public static boolean isValidString(String value) throws IllegalArgumentException {
        return value != null && value.indexOf(58) > -1;
    }

    public static String concatenateId(String feedId, String id) {
        return feedId + ":" + id;
    }

    public static Set<FeedScopedId> parseListOfIds(String s) {
        return Arrays.stream(s.split(",")).map(FeedScopedId::parseId).collect(Collectors.toSet());
    }
}

