/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model;

import java.io.Serializable;
import java.time.Duration;
import java.util.EnumSet;
import org.opentripplanner.model.BookingMethod;
import org.opentripplanner.model.BookingTime;
import org.opentripplanner.model.ContactInfo;

public class BookingInfo
implements Serializable {
    private final ContactInfo contactInfo;
    private final EnumSet<BookingMethod> bookingMethods;
    private final BookingTime earliestBookingTime;
    private final BookingTime latestBookingTime;
    private final Duration minimumBookingNotice;
    private final Duration maximumBookingNotice;
    private final String message;
    private final String pickupMessage;
    private final String dropOffMessage;

    public BookingInfo(ContactInfo contactInfo, EnumSet<BookingMethod> bookingMethods, BookingTime earliestBookingTime, BookingTime latestBookingTime, Duration minimumBookingNotice, Duration maximumBookingNotice, String message, String pickupMessage, String dropOffMessage) {
        this.contactInfo = contactInfo;
        this.bookingMethods = bookingMethods;
        this.message = message;
        this.pickupMessage = pickupMessage;
        this.dropOffMessage = dropOffMessage;
        if (earliestBookingTime != null || latestBookingTime != null) {
            this.earliestBookingTime = earliestBookingTime;
            this.latestBookingTime = latestBookingTime;
            this.minimumBookingNotice = null;
            this.maximumBookingNotice = null;
        } else if (minimumBookingNotice != null || maximumBookingNotice != null) {
            this.earliestBookingTime = null;
            this.latestBookingTime = null;
            this.minimumBookingNotice = minimumBookingNotice;
            this.maximumBookingNotice = maximumBookingNotice;
        } else {
            this.earliestBookingTime = null;
            this.latestBookingTime = null;
            this.minimumBookingNotice = null;
            this.maximumBookingNotice = null;
        }
    }

    public ContactInfo getContactInfo() {
        return this.contactInfo;
    }

    public EnumSet<BookingMethod> bookingMethods() {
        return this.bookingMethods;
    }

    public BookingTime getEarliestBookingTime() {
        return this.earliestBookingTime;
    }

    public BookingTime getLatestBookingTime() {
        return this.latestBookingTime;
    }

    public Duration getMinimumBookingNotice() {
        return this.minimumBookingNotice;
    }

    public Duration getMaximumBookingNotice() {
        return this.maximumBookingNotice;
    }

    public String getMessage() {
        return this.message;
    }

    public String getPickupMessage() {
        return this.pickupMessage;
    }

    public String getDropOffMessage() {
        return this.dropOffMessage;
    }
}

