/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.inspector;

import java.awt.Color;
import org.opentripplanner.inspector.EdgeVertexTileRenderer;
import org.opentripplanner.routing.edgetype.ElevatorHopEdge;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.edgetype.StreetTraversalPermission;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.vertextype.BarrierVertex;
import org.opentripplanner.routing.vertextype.IntersectionVertex;
import org.opentripplanner.routing.vertextype.TransitBoardingAreaVertex;
import org.opentripplanner.routing.vertextype.TransitEntranceVertex;
import org.opentripplanner.routing.vertextype.TransitPathwayNodeVertex;
import org.opentripplanner.routing.vertextype.TransitStopVertex;
import org.opentripplanner.routing.vertextype.VehicleParkingEntranceVertex;
import org.opentripplanner.routing.vertextype.VehicleRentalStationVertex;

public class TraversalPermissionsEdgeRenderer
implements EdgeVertexTileRenderer.EdgeVertexRenderer {
    private static final Color LINK_COLOR_EDGE = Color.ORANGE;
    private static final Color ELEVATOR_COLOR_EDGE = Color.YELLOW;
    private static final Color STAIRS_COLOR_EDGE = Color.PINK;
    private static final Color STREET_COLOR_VERTEX = Color.DARK_GRAY;
    private static final Color TRANSIT_STOP_COLOR_VERTEX = new Color(0.0f, 0.0f, 0.8f);
    private static final Color VEHICLE_RENTAL_COLOR_VERTEX = new Color(0.0f, 0.7f, 0.0f);
    private static final Color PARK_AND_RIDE_COLOR_VERTEX = Color.RED;
    private static final Color BARRIER_COLOR_VERTEX = new Color(0.5803922f, 0.21568628f, 0.24313726f);

    @Override
    public boolean renderEdge(Edge e, EdgeVertexTileRenderer.EdgeVisualAttributes attrs) {
        if (e instanceof StreetEdge) {
            StreetEdge pse = (StreetEdge)e;
            if (pse.isStairs()) {
                attrs.color = STAIRS_COLOR_EDGE;
                attrs.label = "stairs";
            } else {
                attrs.color = this.getColor(pse.getPermission());
                attrs.label = this.getLabel(pse.getPermission());
            }
            if (pse.isMotorVehicleNoThruTraffic()) {
                attrs.label = attrs.label + " car NTT";
            }
            if (pse.isBicycleNoThruTraffic()) {
                attrs.label = attrs.label + " bike NTT";
            }
            if (pse.isWalkNoThruTraffic()) {
                attrs.label = attrs.label + " walk NTT";
            }
        } else if (e instanceof ElevatorHopEdge) {
            ElevatorHopEdge ehe = (ElevatorHopEdge)e;
            attrs.color = ELEVATOR_COLOR_EDGE;
            attrs.label = "elevator";
            if (ehe.wheelchairAccessible) {
                attrs.label = attrs.label + " wheelchair";
            }
            if (ehe.getPermission().allows(StreetTraversalPermission.BICYCLE)) {
                attrs.label = attrs.label + " bike";
            }
            if (ehe.getPermission().allows(StreetTraversalPermission.CAR)) {
                attrs.label = attrs.label + " car";
            }
        } else {
            attrs.color = LINK_COLOR_EDGE;
            attrs.label = "link";
        }
        return true;
    }

    @Override
    public boolean renderVertex(Vertex v, EdgeVertexTileRenderer.VertexVisualAttributes attrs) {
        if (v instanceof IntersectionVertex) {
            attrs.color = STREET_COLOR_VERTEX;
            if (v instanceof BarrierVertex) {
                attrs.color = BARRIER_COLOR_VERTEX;
            }
        } else if (v instanceof TransitStopVertex || v instanceof TransitEntranceVertex || v instanceof TransitPathwayNodeVertex || v instanceof TransitBoardingAreaVertex) {
            attrs.color = TRANSIT_STOP_COLOR_VERTEX;
            attrs.label = v.getDefaultName();
        } else if (v instanceof VehicleRentalStationVertex) {
            attrs.color = VEHICLE_RENTAL_COLOR_VERTEX;
            attrs.label = v.getDefaultName();
        } else if (v instanceof VehicleParkingEntranceVertex) {
            attrs.color = PARK_AND_RIDE_COLOR_VERTEX;
            attrs.label = v.getDefaultName();
        } else {
            return false;
        }
        return true;
    }

    private Color getColor(StreetTraversalPermission permissions) {
        float r = 0.2f;
        float g = 0.2f;
        float b = 0.2f;
        if (permissions.allows(StreetTraversalPermission.PEDESTRIAN)) {
            g += 0.5f;
        }
        if (permissions.allows(StreetTraversalPermission.BICYCLE)) {
            b += 0.5f;
        }
        if (permissions.allows(StreetTraversalPermission.CAR)) {
            r += 0.5f;
        }
        return new Color(r, g, b);
    }

    private String getLabel(StreetTraversalPermission permissions) {
        StringBuffer sb = new StringBuffer();
        if (permissions.allows(StreetTraversalPermission.PEDESTRIAN)) {
            sb.append("walk,");
        }
        if (permissions.allows(StreetTraversalPermission.BICYCLE)) {
            sb.append("bike,");
        }
        if (permissions.allows(StreetTraversalPermission.CAR)) {
            sb.append("car,");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        } else {
            sb.append("none");
        }
        return sb.toString();
    }

    @Override
    public String getName() {
        return "Traversal permissions";
    }
}

