/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.index;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.api.mapping.AgencyMapper;
import org.opentripplanner.api.mapping.AlertMapper;
import org.opentripplanner.api.mapping.FeedInfoMapper;
import org.opentripplanner.api.mapping.FeedScopedIdMapper;
import org.opentripplanner.api.mapping.RouteMapper;
import org.opentripplanner.api.mapping.StopMapper;
import org.opentripplanner.api.mapping.StopTimesInPatternMapper;
import org.opentripplanner.api.mapping.TransferMapper;
import org.opentripplanner.api.mapping.TripMapper;
import org.opentripplanner.api.mapping.TripPatternMapper;
import org.opentripplanner.api.model.ApiAgency;
import org.opentripplanner.api.model.ApiAlert;
import org.opentripplanner.api.model.ApiFeedInfo;
import org.opentripplanner.api.model.ApiPatternShort;
import org.opentripplanner.api.model.ApiRoute;
import org.opentripplanner.api.model.ApiRouteShort;
import org.opentripplanner.api.model.ApiStop;
import org.opentripplanner.api.model.ApiStopShort;
import org.opentripplanner.api.model.ApiStopTimesInPattern;
import org.opentripplanner.api.model.ApiTransfer;
import org.opentripplanner.api.model.ApiTrip;
import org.opentripplanner.api.model.ApiTripShort;
import org.opentripplanner.index.ValidateParameters;
import org.opentripplanner.model.Agency;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.Stop;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.StopTimesInPattern;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.model.WgsCoordinate;
import org.opentripplanner.model.calendar.ServiceDate;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.routing.stoptimes.ArrivalDeparture;
import org.opentripplanner.standalone.server.OTPServer;
import org.opentripplanner.util.PolylineEncoder;
import org.opentripplanner.util.model.EncodedPolylineBean;

@Path(value="/routers/{routerId}/index")
@Produces(value={"application/json"})
public class IndexAPI {
    private static final double MAX_STOP_SEARCH_RADIUS = 5000.0;
    @QueryParam(value="detail")
    private boolean detail = false;
    @QueryParam(value="refs")
    private boolean refs = false;
    private final OTPServer otpServer;
    @Context
    UriInfo uriInfo;

    public IndexAPI(@Context OTPServer otpServer, @PathParam(value="routerId") String routerId) {
        this.otpServer = otpServer;
    }

    @GET
    @Path(value="/feeds")
    public Collection<String> getFeeds() {
        return this.createRoutingService().getFeedIds();
    }

    @GET
    @Path(value="/feeds/{feedId}")
    public ApiFeedInfo getFeedInfo(@PathParam(value="feedId") String feedId) {
        ApiFeedInfo feedInfo = FeedInfoMapper.mapToApi(this.createRoutingService().getFeedInfo(feedId));
        return IndexAPI.validateExist("FeedInfo", feedInfo, "feedId", feedId);
    }

    @GET
    @Path(value="/agencies/{feedId}")
    public Collection<ApiAgency> getAgencies(@PathParam(value="feedId") String feedId) {
        Collection agencies = this.createRoutingService().getAgencies().stream().filter(agency -> agency.getId().getFeedId().equals(feedId)).collect(Collectors.toList());
        IndexAPI.validateExist("Agency", agencies, "feedId", feedId);
        return AgencyMapper.mapToApi(agencies);
    }

    @GET
    @Path(value="/agencies/{feedId}/{agencyId}")
    public ApiAgency getAgency(@PathParam(value="feedId") String feedId, @PathParam(value="agencyId") String agencyId) {
        Agency agency = IndexAPI.getAgency(this.createRoutingService(), feedId, agencyId);
        return AgencyMapper.mapToApi(agency);
    }

    @GET
    @Path(value="/agencies/{feedId}/{agencyId}/routes")
    public Response getAgencyRoutes(@PathParam(value="feedId") String feedId, @PathParam(value="agencyId") String agencyId) {
        RoutingService routingService = this.createRoutingService();
        Agency agency = IndexAPI.getAgency(routingService, feedId, agencyId);
        Collection routes = routingService.getAllRoutes().stream().filter(r -> r.getAgency() == agency).collect(Collectors.toList());
        if (this.detail) {
            return Response.status((Response.Status)Response.Status.OK).entity(RouteMapper.mapToApi(routes)).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity(RouteMapper.mapToApiShort(routes)).build();
    }

    @GET
    @Path(value="/agencies/{feedId}/{agencyId}/alerts")
    public Collection<ApiAlert> getAlertsForTrip(@PathParam(value="feedId") String feedId, @PathParam(value="agencyId") String agencyId) {
        RoutingService routingService = this.createRoutingService();
        AlertMapper alertMapper = new AlertMapper(null);
        FeedScopedId id = new FeedScopedId(feedId, agencyId);
        return alertMapper.mapToApi(routingService.getTransitAlertService().getAgencyAlerts(id));
    }

    @GET
    @Path(value="/stops/{stopId}")
    public ApiStop getStop(@PathParam(value="stopId") String stopIdString) {
        StopLocation stop = IndexAPI.getStop(this.createRoutingService(), stopIdString);
        return StopMapper.mapToApi(stop);
    }

    @GET
    @Path(value="/stops")
    public List<ApiStopShort> getStopsInRadius(@QueryParam(value="minLat") Double minLat, @QueryParam(value="minLon") Double minLon, @QueryParam(value="maxLat") Double maxLat, @QueryParam(value="maxLon") Double maxLon, @QueryParam(value="lat") Double lat, @QueryParam(value="lon") Double lon, @QueryParam(value="radius") Double radius) {
        boolean expectCircle;
        if (this.uriInfo.getQueryParameters().isEmpty()) {
            return StopMapper.mapToApiShort(this.createRoutingService().getAllStops());
        }
        boolean bl = expectCircle = lat != null || lon != null || radius != null;
        if (expectCircle) {
            IndexAPI.verifyParams().withinBounds("lat", lat, -90.0, 90.0).withinBounds("lon", lon, -180.0, 180.0).positiveOrZero("radius", radius).validate();
            radius = Math.min(radius, 5000.0);
            return this.createRoutingService().getStopsInRadius(new WgsCoordinate(lat, lon), radius).stream().map(it -> StopMapper.mapToApiShort((Stop)it.first, ((Double)it.second).intValue())).collect(Collectors.toList());
        }
        IndexAPI.verifyParams().withinBounds("minLat", minLat, -90.0, 90.0).withinBounds("maxLat", maxLat, -90.0, 90.0).withinBounds("minLon", minLon, -180.0, 180.0).withinBounds("maxLon", maxLon, -180.0, 180.0).lessThan("minLat", minLat, "maxLat", maxLat).lessThan("minLon", minLon, "maxLon", maxLon).validate();
        Collection<StopLocation> stops = this.createRoutingService().getStopsByBoundingBox(minLat, minLon, maxLat, maxLon);
        return StopMapper.mapToApiShort(stops);
    }

    @GET
    @Path(value="/stops/{stopId}/routes")
    public List<ApiRouteShort> getRoutesForStop(@PathParam(value="stopId") String stopId) {
        RoutingService routingService = this.createRoutingService();
        StopLocation stop = IndexAPI.getStop(routingService, stopId);
        return routingService.getPatternsForStop(stop).stream().map(TripPattern::getRoute).map(RouteMapper::mapToApiShort).collect(Collectors.toList());
    }

    @GET
    @Path(value="/stops/{stopId}/patterns")
    public List<ApiPatternShort> getPatternsForStop(@PathParam(value="stopId") String stopId) {
        RoutingService routingService = this.createRoutingService();
        StopLocation stop = IndexAPI.getStop(routingService, stopId);
        return routingService.getPatternsForStop(stop).stream().map(TripPatternMapper::mapToApiShort).collect(Collectors.toList());
    }

    @GET
    @Path(value="/stops/{stopId}/stoptimes")
    public Collection<ApiStopTimesInPattern> getStopTimesForStop(@PathParam(value="stopId") String stopIdString, @QueryParam(value="startTime") long startTime, @QueryParam(value="timeRange") @DefaultValue(value="86400") int timeRange, @QueryParam(value="numberOfDepartures") @DefaultValue(value="2") int numberOfDepartures, @QueryParam(value="omitNonPickups") boolean omitNonPickups) {
        RoutingService routingService = this.createRoutingService();
        StopLocation stop = IndexAPI.getStop(routingService, stopIdString);
        return routingService.stopTimesForStop(stop, startTime, timeRange, numberOfDepartures, omitNonPickups ? ArrivalDeparture.DEPARTURES : ArrivalDeparture.BOTH, false).stream().map(StopTimesInPatternMapper::mapToApi).collect(Collectors.toList());
    }

    @GET
    @Path(value="/stops/{stopId}/stoptimes/{date}")
    public List<ApiStopTimesInPattern> getStoptimesForStopAndDate(@PathParam(value="stopId") String stopId, @PathParam(value="date") String date, @QueryParam(value="omitNonPickups") boolean omitNonPickups) {
        RoutingService routingService = this.createRoutingService();
        StopLocation stop = IndexAPI.getStop(routingService, stopId);
        ServiceDate serviceDate = IndexAPI.parseServiceDate("date", date);
        List<StopTimesInPattern> stopTimes = routingService.getStopTimesForStop(stop, serviceDate, omitNonPickups ? ArrivalDeparture.DEPARTURES : ArrivalDeparture.BOTH);
        return StopTimesInPatternMapper.mapToApi(stopTimes);
    }

    @GET
    @Path(value="/stops/{stopId}/transfers")
    public Collection<ApiTransfer> getTransfers(@PathParam(value="stopId") String stopId) {
        RoutingService routingService = this.createRoutingService();
        StopLocation stop = IndexAPI.getStop(routingService, stopId);
        return routingService.getTransfersByStop(stop).stream().map(TransferMapper::mapToApi).collect(Collectors.toList());
    }

    @GET
    @Path(value="/stops/{stopId}/alerts")
    public Collection<ApiAlert> getAlertsForStop(@PathParam(value="stopId") String stopId) {
        RoutingService routingService = this.createRoutingService();
        AlertMapper alertMapper = new AlertMapper(null);
        FeedScopedId id = IndexAPI.createId("stopId", stopId);
        return alertMapper.mapToApi(routingService.getTransitAlertService().getStopAlerts(id));
    }

    @GET
    @Path(value="/routes")
    public List<ApiRouteShort> getRoutes(@QueryParam(value="hasStop") List<String> stopIds) {
        RoutingService routingService = this.createRoutingService();
        Collection<Route> routes = routingService.getAllRoutes();
        if (stopIds != null) {
            routes = new ArrayList<Route>(routes);
            for (String stopId : stopIds) {
                StopLocation stop = IndexAPI.getStop(routingService, stopId);
                HashSet<Route> routesHere = new HashSet<Route>();
                for (TripPattern pattern : routingService.getPatternsForStop(stop)) {
                    routesHere.add(pattern.getRoute());
                }
                routes.retainAll(routesHere);
            }
        }
        return RouteMapper.mapToApiShort(routes);
    }

    @GET
    @Path(value="/routes/{routeId}")
    public ApiRoute getRoute(@PathParam(value="routeId") String routeId) {
        Route route = IndexAPI.getRoute(this.createRoutingService(), routeId);
        return RouteMapper.mapToApi(route);
    }

    @GET
    @Path(value="/routes/{routeId}/patterns")
    public List<ApiPatternShort> getPatternsForRoute(@PathParam(value="routeId") String routeId) {
        RoutingService routingService = this.createRoutingService();
        Collection patterns = routingService.getPatternsForRoute().get((Object)IndexAPI.getRoute(routingService, routeId));
        return TripPatternMapper.mapToApiShort(patterns);
    }

    @GET
    @Path(value="/routes/{routeId}/stops")
    public List<ApiStopShort> getStopsForRoute(@PathParam(value="routeId") String routeId) {
        RoutingService routingService = this.createRoutingService();
        Route route = IndexAPI.getRoute(routingService, routeId);
        HashSet<StopLocation> stops = new HashSet<StopLocation>();
        Collection patterns = routingService.getPatternsForRoute().get((Object)route);
        for (TripPattern pattern : patterns) {
            stops.addAll(pattern.getStops());
        }
        return StopMapper.mapToApiShort(stops);
    }

    @GET
    @Path(value="/routes/{routeId}/trips")
    public List<ApiTripShort> getTripsForRoute(@PathParam(value="routeId") String routeId) {
        RoutingService routingService = this.createRoutingService();
        Route route = IndexAPI.getRoute(routingService, routeId);
        Collection patterns = routingService.getPatternsForRoute().get((Object)route);
        return patterns.stream().flatMap(TripPattern::scheduledTripsAsStream).map(TripMapper::mapToApiShort).collect(Collectors.toList());
    }

    @GET
    @Path(value="/routes/{routeId}/alerts")
    public Collection<ApiAlert> getAlertsForRoute(@PathParam(value="routeId") String routeId) {
        RoutingService routingService = this.createRoutingService();
        AlertMapper alertMapper = new AlertMapper(null);
        FeedScopedId id = IndexAPI.createId("routeId", routeId);
        return alertMapper.mapToApi(routingService.getTransitAlertService().getRouteAlerts(id));
    }

    @GET
    @Path(value="/trips/{tripId}")
    public ApiTrip getTrip(@PathParam(value="tripId") String tripId) {
        Trip trip = IndexAPI.getTrip(this.createRoutingService(), tripId);
        return TripMapper.mapToApi(trip);
    }

    @GET
    @Path(value="/trips/{tripId}/stops")
    public List<ApiStopShort> getStopsForTrip(@PathParam(value="tripId") String tripId) {
        List<StopLocation> stops = IndexAPI.getTripPatternForTripId(this.createRoutingService(), tripId).getStops();
        return StopMapper.mapToApiShort(stops);
    }

    @GET
    @Path(value="/trips/{tripId}/semanticHash")
    public String getSemanticHashForTrip(@PathParam(value="tripId") String tripId) {
        RoutingService routingService = this.createRoutingService();
        Trip trip = IndexAPI.getTrip(routingService, tripId);
        TripPattern pattern = IndexAPI.getTripPattern(routingService, trip);
        return pattern.semanticHashString(trip);
    }

    @GET
    @Path(value="/trips/{tripId}/stoptimes")
    public List<TripTimeOnDate> getStoptimesForTrip(@PathParam(value="tripId") String tripId) {
        RoutingService routingService = this.createRoutingService();
        Trip trip = IndexAPI.getTrip(routingService, tripId);
        TripPattern pattern = IndexAPI.getTripPattern(routingService, trip);
        Timetable table = routingService.getTimetableForTripPattern(pattern);
        return TripTimeOnDate.fromTripTimes(table, trip);
    }

    @GET
    @Path(value="/trips/{tripId}/geometry")
    public EncodedPolylineBean getGeometryForTrip(@PathParam(value="tripId") String tripId) {
        TripPattern pattern = IndexAPI.getTripPatternForTripId(this.createRoutingService(), tripId);
        return PolylineEncoder.createEncodings((Geometry)pattern.getGeometry());
    }

    @GET
    @Path(value="/trips/{tripId}/alerts")
    public Collection<ApiAlert> getAlertsForTrip(@PathParam(value="tripId") String tripId) {
        RoutingService routingService = this.createRoutingService();
        AlertMapper alertMapper = new AlertMapper(null);
        FeedScopedId id = IndexAPI.createId("tripId", tripId);
        return alertMapper.mapToApi(routingService.getTransitAlertService().getTripAlerts(id, null));
    }

    @GET
    @Path(value="/patterns")
    public List<ApiPatternShort> getPatterns() {
        Collection<TripPattern> patterns = this.createRoutingService().getTripPatterns();
        return TripPatternMapper.mapToApiShort(patterns);
    }

    @GET
    @Path(value="/patterns/{patternId}")
    public ApiPatternShort getPattern(@PathParam(value="patternId") String patternId) {
        TripPattern pattern = IndexAPI.getTripPattern(this.createRoutingService(), patternId);
        return TripPatternMapper.mapToApiDetailed(pattern);
    }

    @GET
    @Path(value="/patterns/{patternId}/trips")
    public List<ApiTripShort> getTripsForPattern(@PathParam(value="patternId") String patternId) {
        Stream<Trip> trips = IndexAPI.getTripPattern(this.createRoutingService(), patternId).scheduledTripsAsStream();
        return TripMapper.mapToApiShort(trips);
    }

    @GET
    @Path(value="/patterns/{patternId}/stops")
    public List<ApiStopShort> getStopsForPattern(@PathParam(value="patternId") String patternId) {
        List<StopLocation> stops = IndexAPI.getTripPattern(this.createRoutingService(), patternId).getStops();
        return StopMapper.mapToApiShort(stops);
    }

    @GET
    @Path(value="/patterns/{patternId}/semanticHash")
    public String getSemanticHashForPattern(@PathParam(value="patternId") String patternId) {
        TripPattern tripPattern = IndexAPI.getTripPattern(this.createRoutingService(), patternId);
        return tripPattern.semanticHashString(null);
    }

    @GET
    @Path(value="/patterns/{patternId}/geometry")
    public EncodedPolylineBean getGeometryForPattern(@PathParam(value="patternId") String patternId) {
        LineString line = IndexAPI.getTripPattern(this.createRoutingService(), patternId).getGeometry();
        return PolylineEncoder.createEncodings((Geometry)line);
    }

    @GET
    @Path(value="/patterns/{patternId}/alerts")
    public Collection<ApiAlert> getAlertsForPattern(@PathParam(value="patternId") String patternId) {
        RoutingService routingService = this.createRoutingService();
        AlertMapper alertMapper = new AlertMapper(null);
        TripPattern pattern = IndexAPI.getTripPattern(this.createRoutingService(), patternId);
        return alertMapper.mapToApi(routingService.getTransitAlertService().getDirectionAndRouteAlerts(pattern.getDirection().gtfsCode, pattern.getRoute().getId()));
    }

    @GET
    @Path(value="/services")
    public Response getServices() {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)"NONE").build();
    }

    @GET
    @Path(value="/services/{serviceId}")
    public Response getServices(@PathParam(value="serviceId") String serviceId) {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)"NONE").build();
    }

    private RoutingService createRoutingService() {
        return this.otpServer.createRoutingRequestService();
    }

    private static FeedScopedId createId(String name, String value) {
        return FeedScopedIdMapper.mapToDomain(name, value);
    }

    private static ServiceDate parseServiceDate(String label, String date) {
        try {
            return ServiceDate.parseString(date);
        }
        catch (ParseException e) {
            throw new BadRequestException("Unable to parse date, not on format: YYYY-MM-DD. " + label + ": '" + date + "'");
        }
    }

    private static ValidateParameters verifyParams() {
        return new ValidateParameters();
    }

    private static <T> T validateExist(String eName, T entity, String keyLabel, Object key) {
        if (entity != null) {
            return entity;
        }
        throw IndexAPI.notFoundException(eName, keyLabel, key);
    }

    private static NotFoundException notFoundException(String eName, String keyLbl, Object key) {
        return IndexAPI.notFoundException(eName, keyLbl + ": " + key);
    }

    private static NotFoundException notFoundException(String entity, String details) {
        return new NotFoundException(entity + " not found. " + details);
    }

    private static Agency getAgency(RoutingService routingService, String feedId, String agencyId) {
        Agency agency = routingService.getAgencyForId(new FeedScopedId(feedId, agencyId));
        if (agency == null) {
            throw IndexAPI.notFoundException("Agency", "feedId: " + feedId + ", agencyId: " + agencyId);
        }
        return agency;
    }

    private static StopLocation getStop(RoutingService routingService, String stopId) {
        StopLocation stop = routingService.getStopForId(IndexAPI.createId("stopId", stopId));
        return IndexAPI.validateExist("Stop", stop, "stopId", stop);
    }

    private static Route getRoute(RoutingService routingService, String routeId) {
        Route route = routingService.getRouteForId(IndexAPI.createId("routeId", routeId));
        return IndexAPI.validateExist("Route", route, "routeId", routeId);
    }

    private static Trip getTrip(RoutingService routingService, String tripId) {
        Trip trip = routingService.getTripForId().get(IndexAPI.createId("tripId", tripId));
        return IndexAPI.validateExist("Trip", trip, "tripId", tripId);
    }

    private static TripPattern getTripPattern(RoutingService routingService, String tripPatternId) {
        FeedScopedId id = IndexAPI.createId("patternId", tripPatternId);
        TripPattern pattern = routingService.getTripPatternForId(id);
        return IndexAPI.validateExist("TripPattern", pattern, "patternId", tripPatternId);
    }

    private static TripPattern getTripPatternForTripId(RoutingService routingService, String tripId) {
        return IndexAPI.getTripPattern(routingService, IndexAPI.getTrip(routingService, tripId));
    }

    private static TripPattern getTripPattern(RoutingService routingService, Trip trip) {
        TripPattern pattern = routingService.getPatternForTrip().get(trip);
        return IndexAPI.validateExist("TripPattern", pattern, "trip", trip.getId());
    }
}

