/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opentripplanner.gtfs.mapping.AgencyAndIdMapper;
import org.opentripplanner.gtfs.mapping.BikeAccessMapper;
import org.opentripplanner.gtfs.mapping.RouteMapper;
import org.opentripplanner.model.Direction;
import org.opentripplanner.model.Trip;
import org.opentripplanner.util.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TripMapper {
    private static final Logger LOG = LoggerFactory.getLogger(TripMapper.class);
    private final RouteMapper routeMapper;
    private final Map<org.onebusaway.gtfs.model.Trip, Trip> mappedTrips = new HashMap<org.onebusaway.gtfs.model.Trip, Trip>();

    TripMapper(RouteMapper routeMapper) {
        this.routeMapper = routeMapper;
    }

    Collection<Trip> map(Collection<org.onebusaway.gtfs.model.Trip> trips) {
        return MapUtils.mapToList(trips, this::map);
    }

    Trip map(org.onebusaway.gtfs.model.Trip orginal) {
        return orginal == null ? null : this.mappedTrips.computeIfAbsent(orginal, this::doMap);
    }

    Collection<Trip> getMappedTrips() {
        return this.mappedTrips.values();
    }

    private Trip doMap(org.onebusaway.gtfs.model.Trip rhs) {
        Trip lhs = new Trip(AgencyAndIdMapper.mapAgencyAndId(rhs.getId()));
        lhs.setRoute(this.routeMapper.map(rhs.getRoute()));
        lhs.setServiceId(AgencyAndIdMapper.mapAgencyAndId(rhs.getServiceId()));
        lhs.setTripShortName(rhs.getTripShortName());
        lhs.setTripHeadsign(rhs.getTripHeadsign());
        lhs.setRouteShortName(rhs.getRouteShortName());
        lhs.setDirection(Direction.valueOfGtfsCode(TripMapper.mapDirectionId(rhs)));
        lhs.setBlockId(rhs.getBlockId());
        lhs.setShapeId(AgencyAndIdMapper.mapAgencyAndId(rhs.getShapeId()));
        lhs.setWheelchairAccessible(rhs.getWheelchairAccessible());
        lhs.setBikesAllowed(BikeAccessMapper.mapForTrip(rhs));
        lhs.setFareId(rhs.getFareId());
        return lhs;
    }

    private static int mapDirectionId(org.onebusaway.gtfs.model.Trip trip) {
        try {
            String directionId = trip.getDirectionId();
            if (directionId == null || directionId.isBlank()) {
                return -1;
            }
            return Integer.parseInt(directionId);
        }
        catch (NumberFormatException e) {
            LOG.debug("Trip {} does not have direction id, defaults to -1", (Object)trip);
            return -1;
        }
    }
}

