/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.onebusaway.gtfs.model.Transfer;
import org.opentripplanner.gtfs.mapping.RouteMapper;
import org.opentripplanner.gtfs.mapping.StationMapper;
import org.opentripplanner.gtfs.mapping.StopMapper;
import org.opentripplanner.gtfs.mapping.TripMapper;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.Station;
import org.opentripplanner.model.Stop;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.TripStopTimes;
import org.opentripplanner.model.transfer.ConstrainedTransfer;
import org.opentripplanner.model.transfer.RouteStationTransferPoint;
import org.opentripplanner.model.transfer.RouteStopTransferPoint;
import org.opentripplanner.model.transfer.StationTransferPoint;
import org.opentripplanner.model.transfer.StopTransferPoint;
import org.opentripplanner.model.transfer.TransferConstraint;
import org.opentripplanner.model.transfer.TransferPoint;
import org.opentripplanner.model.transfer.TransferPriority;
import org.opentripplanner.model.transfer.TripTransferPoint;
import org.opentripplanner.util.logging.ThrottleLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransferMapper {
    private static final Logger LOG = LoggerFactory.getLogger(TransferMapper.class);
    private static final Logger FIXED_ROUTE_ERROR = ThrottleLogger.throttle(LOG);
    private static final int RECOMMENDED = 0;
    private static final int GUARANTEED = 1;
    private static final int MIN_TIME = 2;
    private static final int FORBIDDEN = 3;
    private static final int STAY_SEATED = 4;
    private static final int STAY_SEATED_NOT_ALLOWED = 5;
    private final RouteMapper routeMapper;
    private final StationMapper stationMapper;
    private final StopMapper stopMapper;
    private final TripMapper tripMapper;
    private final TripStopTimes stopTimesByTrip;
    private final Multimap<Route, Trip> tripsByRoute = ArrayListMultimap.create();

    TransferMapper(RouteMapper routeMapper, StationMapper stationMapper, StopMapper stopMapper, TripMapper tripMapper, TripStopTimes stopTimesByTrip) {
        this.routeMapper = routeMapper;
        this.stationMapper = stationMapper;
        this.stopMapper = stopMapper;
        this.tripMapper = tripMapper;
        this.stopTimesByTrip = stopTimesByTrip;
    }

    static TransferPriority mapTypeToPriority(int type) {
        switch (type) {
            case 3: {
                return TransferPriority.NOT_ALLOWED;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return TransferPriority.ALLOWED;
            }
            case 0: {
                return TransferPriority.RECOMMENDED;
            }
        }
        throw new IllegalArgumentException("Mapping missing for type: " + type);
    }

    Collection<ConstrainedTransfer> map(Collection<Transfer> allTransfers) {
        this.setup(!allTransfers.isEmpty());
        return allTransfers.stream().map(this::map).filter(Objects::nonNull).collect(Collectors.toList());
    }

    ConstrainedTransfer map(Transfer rhs) {
        Trip toTrip;
        Trip fromTrip = this.tripMapper.map(rhs.getFromTrip());
        TransferConstraint constraint = this.mapConstraint(rhs, fromTrip, toTrip = this.tripMapper.map(rhs.getToTrip()));
        if (constraint.isRegularTransfer()) {
            LOG.warn("Transfer skipped - no effect on routing: " + rhs);
            return null;
        }
        if (constraint.isStaySeated() && (fromTrip == null || toTrip == null)) {
            LOG.warn("Transfer skipped - from_trip_id and to_trip_id must exist for in-seat transfer");
            return null;
        }
        TransferPoint fromPoint = this.mapTransferPoint(rhs.getFromStop(), rhs.getFromRoute(), fromTrip, false);
        TransferPoint toPoint = this.mapTransferPoint(rhs.getToStop(), rhs.getToRoute(), toTrip, true);
        return new ConstrainedTransfer(null, fromPoint, toPoint, constraint);
    }

    private void setup(boolean run) {
        if (!run) {
            return;
        }
        for (Trip trip : this.tripMapper.getMappedTrips()) {
            this.tripsByRoute.put((Object)trip.getRoute(), (Object)trip);
        }
    }

    private TransferConstraint mapConstraint(Transfer rhs, Trip fromTrip, Trip toTrip) {
        TransferConstraint.Builder builder = TransferConstraint.create();
        builder.guaranteed(rhs.getTransferType() == 1);
        builder.staySeated(rhs.getTransferType() == 4 || rhs.getTransferType() != 5 && this.sameBlockId(fromTrip, toTrip));
        builder.priority(TransferMapper.mapTypeToPriority(rhs.getTransferType()));
        if (rhs.isMinTransferTimeSet()) {
            builder.minTransferTime(rhs.getMinTransferTime());
        }
        return builder.build();
    }

    private TransferPoint mapTransferPoint(org.onebusaway.gtfs.model.Stop rhsStopOrStation, org.onebusaway.gtfs.model.Route rhsRoute, Trip trip, boolean boardTrip) {
        Route route = this.routeMapper.map(rhsRoute);
        Station station = null;
        Stop stop = null;
        if (rhsStopOrStation.getLocationType() == 0) {
            stop = this.stopMapper.map(rhsStopOrStation);
        } else {
            station = this.stationMapper.map(rhsStopOrStation);
        }
        if (trip != null) {
            int stopPositionInPattern = this.stopPosition(trip, stop, station, boardTrip);
            return stopPositionInPattern < 0 ? null : new TripTransferPoint(trip, stopPositionInPattern);
        }
        if (route != null) {
            if (stop != null) {
                return new RouteStopTransferPoint(route, stop);
            }
            if (station != null) {
                return new RouteStationTransferPoint(route, station);
            }
        } else {
            if (stop != null) {
                return new StopTransferPoint(stop);
            }
            if (station != null) {
                return new StationTransferPoint(station);
            }
        }
        throw new IllegalStateException("Should not get here!");
    }

    private int stopPosition(Trip trip, Stop stop, Station station, boolean boardTrip) {
        List<StopTime> stopTimes = this.stopTimesByTrip.get(trip);
        int firstStopPos = boardTrip ? 0 : 1;
        int lastStopPos = stopTimes.size() - (boardTrip ? 1 : 0);
        Predicate<StopLocation> stopMatches = station != null ? s -> s instanceof Stop && ((Stop)s).getParentStation() == station : s -> s == stop;
        for (int i = firstStopPos; i < lastStopPos; ++i) {
            StopTime stopTime = stopTimes.get(i);
            if (boardTrip && stopTime.getPickupType().isNotRoutable() || !boardTrip && stopTime.getDropOffType().isNotRoutable() || !stopMatches.test(stopTime.getStop())) continue;
            return i;
        }
        return -1;
    }

    private boolean sameBlockId(Trip a, Trip b) {
        if (a == null || b == null) {
            return false;
        }
        return a.getBlockId() != null && a.getBlockId().equals(b.getBlockId());
    }
}

