/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.util.HashMap;
import java.util.Map;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.ParentStationNotFound;
import org.opentripplanner.model.BoardingArea;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.Station;
import org.opentripplanner.model.StationElement;
import org.opentripplanner.model.Stop;
import org.opentripplanner.model.impl.EntityById;

class StopToParentStationLinker {
    private final EntityById<Station> otpStations = new EntityById();
    private final EntityById<StationElement> otpStationElements = new EntityById();
    private final EntityById<BoardingArea> boardingAreas = new EntityById();
    private final Map<StationElement, FeedScopedId> stationElementsToStations = new HashMap<StationElement, FeedScopedId>();
    private final Map<BoardingArea, FeedScopedId> boardingAreasToStops = new HashMap<BoardingArea, FeedScopedId>();
    private final DataImportIssueStore issueStore;

    StopToParentStationLinker(DataImportIssueStore issueStore) {
        this.issueStore = issueStore;
    }

    void addStation(Station station) {
        this.otpStations.add(station);
    }

    void addStationElement(StationElement stationElement, String stationId) {
        this.otpStationElements.add(stationElement);
        if (stationId != null) {
            this.stationElementsToStations.put(stationElement, new FeedScopedId(stationElement.getId().getFeedId(), stationId));
        }
    }

    void addBoardingArea(BoardingArea boardingArea, String stopId) {
        this.boardingAreas.add(boardingArea);
        this.boardingAreasToStops.put(boardingArea, new FeedScopedId(boardingArea.getId().getFeedId(), stopId));
    }

    void link() {
        for (Map.Entry<StationElement, FeedScopedId> entry : this.stationElementsToStations.entrySet()) {
            StationElement stationElement = entry.getKey();
            FeedScopedId stationId = entry.getValue();
            Station otpStation = this.otpStations.get(stationId);
            if (otpStation == null) {
                this.issueStore.add(new ParentStationNotFound(stationElement, stationId.getId()));
                continue;
            }
            stationElement.setParentStation(otpStation);
            if (!(stationElement instanceof Stop)) continue;
            otpStation.addChildStop((Stop)stationElement);
        }
        for (Map.Entry<StationElement, FeedScopedId> entry : this.boardingAreasToStops.entrySet()) {
            BoardingArea boardingArea = (BoardingArea)entry.getKey();
            FeedScopedId stopId = entry.getValue();
            StationElement otpStop = this.otpStationElements.get(stopId);
            if (!(otpStop instanceof Stop)) {
                this.issueStore.add(new ParentStationNotFound(boardingArea, stopId.getId()));
                continue;
            }
            boardingArea.setParentStop((Stop)otpStop);
            ((Stop)otpStop).addBoardingArea(boardingArea);
            boardingArea.setParentStation(otpStop.getParentStation());
        }
    }
}

