/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import org.onebusaway.gtfs.model.Stop;
import org.opentripplanner.gtfs.mapping.AgencyAndIdMapper;
import org.opentripplanner.gtfs.mapping.WgsCoordinateMapper;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.StopLevel;
import org.opentripplanner.model.WgsCoordinate;
import org.opentripplanner.model.WheelChairBoarding;

class StopMappingWrapper {
    final Stop stop;

    public StopMappingWrapper(Stop stop) {
        this.stop = stop;
    }

    public FeedScopedId getId() {
        return AgencyAndIdMapper.mapAgencyAndId(this.stop.getId());
    }

    public String getName() {
        return this.stop.getName();
    }

    public String getCode() {
        return this.stop.getCode();
    }

    public String getDescription() {
        return this.stop.getDesc();
    }

    public WgsCoordinate getCoordinate() {
        return WgsCoordinateMapper.mapToDomain(this.stop);
    }

    public WheelChairBoarding getWheelchairBoarding() {
        return WheelChairBoarding.valueOfGtfsCode(this.stop.getWheelchairBoarding());
    }

    public StopLevel getLevel() {
        if (this.stop.getLevel() == null) {
            return null;
        }
        return new StopLevel(this.stop.getLevel().getName(), this.stop.getLevel().getIndex());
    }
}

