/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.opentripplanner.gtfs.mapping.StopMappingWrapper;
import org.opentripplanner.gtfs.mapping.TransitModeMapper;
import org.opentripplanner.model.FareZone;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.Stop;
import org.opentripplanner.util.MapUtils;

class StopMapper {
    private Map<org.onebusaway.gtfs.model.Stop, Stop> mappedStops = new HashMap<org.onebusaway.gtfs.model.Stop, Stop>();

    StopMapper() {
    }

    Collection<Stop> map(Collection<org.onebusaway.gtfs.model.Stop> allStops) {
        return MapUtils.mapToList(allStops, this::map);
    }

    Stop map(org.onebusaway.gtfs.model.Stop orginal) {
        return orginal == null ? null : this.mappedStops.computeIfAbsent(orginal, this::doMap);
    }

    private Stop doMap(org.onebusaway.gtfs.model.Stop gtfsStop) {
        if (gtfsStop.getLocationType() != 0) {
            throw new IllegalArgumentException("Expected type 0, but got " + gtfsStop.getLocationType());
        }
        StopMappingWrapper base = new StopMappingWrapper(gtfsStop);
        Collection<FareZone> fareZones = this.getTariffZones(gtfsStop.getZoneId(), gtfsStop.getId().getAgencyId());
        return new Stop(base.getId(), base.getName(), base.getCode(), base.getDescription(), base.getCoordinate(), base.getWheelchairBoarding(), base.getLevel(), gtfsStop.getPlatformCode(), fareZones, gtfsStop.getUrl(), gtfsStop.getTimezone() == null ? null : TimeZone.getTimeZone(gtfsStop.getTimezone()), TransitModeMapper.mapMode(gtfsStop.getVehicleType()), null);
    }

    private Collection<FareZone> getTariffZones(String zoneId, String agencyId) {
        return zoneId != null ? Collections.singletonList(new FareZone(new FeedScopedId(agencyId, zoneId), null)) : Collections.emptyList();
    }
}

