/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.onebusaway.gtfs.model.Stop;
import org.opentripplanner.gtfs.mapping.AgencyAndIdMapper;
import org.opentripplanner.gtfs.mapping.WgsCoordinateMapper;
import org.opentripplanner.model.Station;

class StationMapper {
    private Map<Stop, Station> mappedStops = new HashMap<Stop, Station>();

    StationMapper() {
    }

    Station map(Stop orginal) {
        return orginal == null ? null : this.mappedStops.computeIfAbsent(orginal, this::doMap);
    }

    private Station doMap(Stop rhs) {
        if (rhs.getLocationType() != 1) {
            throw new IllegalArgumentException("Expected type 1, but got " + rhs.getLocationType());
        }
        return new Station(AgencyAndIdMapper.mapAgencyAndId(rhs.getId()), rhs.getName(), WgsCoordinateMapper.mapToDomain(rhs), rhs.getCode(), rhs.getDesc(), rhs.getUrl(), rhs.getTimezone() == null ? null : TimeZone.getTimeZone(rhs.getTimezone()), null);
    }
}

