/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.onebusaway.gtfs.model.Stop;
import org.opentripplanner.gtfs.mapping.StopMappingWrapper;
import org.opentripplanner.model.PathwayNode;
import org.opentripplanner.util.MapUtils;

class PathwayNodeMapper {
    static final String DEFAULT_NAME = "Pathway node";
    private final Map<Stop, PathwayNode> mappedNodes = new HashMap<Stop, PathwayNode>();

    PathwayNodeMapper() {
    }

    Collection<PathwayNode> map(Collection<Stop> allNodes) {
        return MapUtils.mapToList(allNodes, this::map);
    }

    PathwayNode map(Stop orginal) {
        return orginal == null ? null : this.mappedNodes.computeIfAbsent(orginal, this::doMap);
    }

    private PathwayNode doMap(Stop gtfsStop) {
        if (gtfsStop.getLocationType() != 3) {
            throw new IllegalArgumentException("Expected type 3, but got " + gtfsStop.getLocationType());
        }
        StopMappingWrapper base = new StopMappingWrapper(gtfsStop);
        return new PathwayNode(base.getId(), Objects.requireNonNullElse(base.getName(), DEFAULT_NAME), base.getCode(), base.getDescription(), base.getCoordinate(), base.getWheelchairBoarding(), base.getLevel());
    }
}

