/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.onebusaway.gtfs.model.Stop;
import org.opentripplanner.gtfs.mapping.AgencyAndIdMapper;
import org.opentripplanner.gtfs.mapping.BoardingAreaMapper;
import org.opentripplanner.gtfs.mapping.EntranceMapper;
import org.opentripplanner.gtfs.mapping.PathwayNodeMapper;
import org.opentripplanner.gtfs.mapping.StopMapper;
import org.opentripplanner.model.Pathway;
import org.opentripplanner.model.StationElement;
import org.opentripplanner.util.MapUtils;

class PathwayMapper {
    private final StopMapper stopMapper;
    private EntranceMapper entranceMapper;
    private PathwayNodeMapper nodeMapper;
    private BoardingAreaMapper boardingAreaMapper;
    private Map<org.onebusaway.gtfs.model.Pathway, Pathway> mappedPathways = new HashMap<org.onebusaway.gtfs.model.Pathway, Pathway>();

    PathwayMapper(StopMapper stopMapper, EntranceMapper entranceMapper, PathwayNodeMapper nodeMapper, BoardingAreaMapper boardingAreaMapper) {
        this.stopMapper = stopMapper;
        this.entranceMapper = entranceMapper;
        this.nodeMapper = nodeMapper;
        this.boardingAreaMapper = boardingAreaMapper;
    }

    Collection<Pathway> map(Collection<org.onebusaway.gtfs.model.Pathway> allPathways) {
        return MapUtils.mapToList(allPathways, this::map);
    }

    Pathway map(org.onebusaway.gtfs.model.Pathway orginal) {
        return orginal == null ? null : this.mappedPathways.computeIfAbsent(orginal, this::doMap);
    }

    private Pathway doMap(org.onebusaway.gtfs.model.Pathway rhs) {
        Pathway lhs = new Pathway(AgencyAndIdMapper.mapAgencyAndId(rhs.getId()));
        lhs.setPathwayMode(rhs.getPathwayMode());
        if (rhs.isTraversalTimeSet()) {
            lhs.setTraversalTime(rhs.getTraversalTime());
        }
        lhs.setName(rhs.getSignpostedAs());
        lhs.setReversedName(rhs.getReversedSignpostedAs());
        if (rhs.isLengthSet()) {
            lhs.setLength(rhs.getLength());
        }
        if (rhs.isStairCountSet()) {
            lhs.setStairCount(rhs.getStairCount());
        }
        if (rhs.isMaxSlopeSet()) {
            lhs.setSlope(rhs.getMaxSlope());
        }
        lhs.setBidirectional(rhs.getIsBidirectional() == 1);
        lhs.setFromStop(this.mapStationElement(rhs.getFromStop()));
        lhs.setToStop(this.mapStationElement(rhs.getToStop()));
        return lhs;
    }

    private StationElement mapStationElement(Stop stop) {
        if (stop != null) {
            switch (stop.getLocationType()) {
                case 0: {
                    return this.stopMapper.map(stop);
                }
                case 2: {
                    return this.entranceMapper.map(stop);
                }
                case 3: {
                    return this.nodeMapper.map(stop);
                }
                case 4: {
                    return this.boardingAreaMapper.map(stop);
                }
            }
        }
        return null;
    }
}

