/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.onebusaway.gtfs.model.Location;
import org.opentripplanner.common.geometry.GeometryUtils;
import org.opentripplanner.common.geometry.UnsupportedGeometryException;
import org.opentripplanner.gtfs.mapping.AgencyAndIdMapper;
import org.opentripplanner.model.FlexStopLocation;
import org.opentripplanner.util.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationMapper {
    private static Logger LOG = LoggerFactory.getLogger(LocationMapper.class);
    private Map<Location, FlexStopLocation> mappedLocations = new HashMap<Location, FlexStopLocation>();

    Collection<FlexStopLocation> map(Collection<Location> allLocations) {
        return MapUtils.mapToList(allLocations, this::map);
    }

    FlexStopLocation map(Location orginal) {
        return orginal == null ? null : this.mappedLocations.computeIfAbsent(orginal, this::doMap);
    }

    private FlexStopLocation doMap(Location gtfsLocation) {
        FlexStopLocation otpLocation = new FlexStopLocation(AgencyAndIdMapper.mapAgencyAndId(gtfsLocation.getId()));
        otpLocation.setName(gtfsLocation.getName());
        otpLocation.setUrl(gtfsLocation.getUrl());
        otpLocation.setDescription(gtfsLocation.getDescription());
        otpLocation.setZoneId(gtfsLocation.getZoneId());
        try {
            otpLocation.setGeometry(GeometryUtils.convertGeoJsonToJtsGeometry(gtfsLocation.getGeometry()));
        }
        catch (UnsupportedGeometryException e) {
            LOG.warn("Unsupported geometry type for " + gtfsLocation.getId());
        }
        return otpLocation;
    }
}

