/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.onebusaway.gtfs.model.Location;
import org.onebusaway.gtfs.model.LocationGroup;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopLocation;
import org.opentripplanner.gtfs.mapping.AgencyAndIdMapper;
import org.opentripplanner.gtfs.mapping.LocationMapper;
import org.opentripplanner.gtfs.mapping.StopMapper;
import org.opentripplanner.model.FlexLocationGroup;
import org.opentripplanner.util.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationGroupMapper {
    private static Logger LOG = LoggerFactory.getLogger(LocationGroupMapper.class);
    private final StopMapper stopMapper;
    private final LocationMapper locationMapper;
    private final Map<LocationGroup, FlexLocationGroup> mappedLocationGroups = new HashMap<LocationGroup, FlexLocationGroup>();

    public LocationGroupMapper(StopMapper stopMapper, LocationMapper locationMapper) {
        this.stopMapper = stopMapper;
        this.locationMapper = locationMapper;
    }

    Collection<FlexLocationGroup> map(Collection<LocationGroup> allLocationGroups) {
        return MapUtils.mapToList(allLocationGroups, this::map);
    }

    FlexLocationGroup map(LocationGroup orginal) {
        return orginal == null ? null : this.mappedLocationGroups.computeIfAbsent(orginal, this::doMap);
    }

    private FlexLocationGroup doMap(LocationGroup element) {
        FlexLocationGroup locationGroup = new FlexLocationGroup(AgencyAndIdMapper.mapAgencyAndId(element.getId()));
        locationGroup.setName(element.getName());
        for (StopLocation location : element.getLocations()) {
            if (location instanceof Stop) {
                locationGroup.addLocation(this.stopMapper.map((Stop)location));
                continue;
            }
            if (location instanceof Location) {
                locationGroup.addLocation(this.locationMapper.map((Location)location));
                continue;
            }
            if (location instanceof LocationGroup) {
                throw new RuntimeException("Nested LocationGroups are not allowed");
            }
            throw new RuntimeException("Unknown location type: " + location.getClass().getSimpleName());
        }
        return locationGroup;
    }
}

