/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.gtfs.mapping.AgencyMapper;
import org.opentripplanner.gtfs.mapping.BoardingAreaMapper;
import org.opentripplanner.gtfs.mapping.BookingRuleMapper;
import org.opentripplanner.gtfs.mapping.EntranceMapper;
import org.opentripplanner.gtfs.mapping.FareAttributeMapper;
import org.opentripplanner.gtfs.mapping.FareRuleMapper;
import org.opentripplanner.gtfs.mapping.FeedInfoMapper;
import org.opentripplanner.gtfs.mapping.FrequencyMapper;
import org.opentripplanner.gtfs.mapping.LocationGroupMapper;
import org.opentripplanner.gtfs.mapping.LocationMapper;
import org.opentripplanner.gtfs.mapping.PathwayMapper;
import org.opentripplanner.gtfs.mapping.PathwayNodeMapper;
import org.opentripplanner.gtfs.mapping.RouteMapper;
import org.opentripplanner.gtfs.mapping.ServiceCalendarDateMapper;
import org.opentripplanner.gtfs.mapping.ServiceCalendarMapper;
import org.opentripplanner.gtfs.mapping.ShapePointMapper;
import org.opentripplanner.gtfs.mapping.StationMapper;
import org.opentripplanner.gtfs.mapping.StopMapper;
import org.opentripplanner.gtfs.mapping.StopTimeMapper;
import org.opentripplanner.gtfs.mapping.StopToParentStationLinker;
import org.opentripplanner.gtfs.mapping.TransferMapper;
import org.opentripplanner.gtfs.mapping.TripMapper;
import org.opentripplanner.model.BoardingArea;
import org.opentripplanner.model.Entrance;
import org.opentripplanner.model.PathwayNode;
import org.opentripplanner.model.ShapePoint;
import org.opentripplanner.model.Station;
import org.opentripplanner.model.Stop;
import org.opentripplanner.model.impl.OtpTransitServiceBuilder;

public class GTFSToOtpTransitServiceMapper {
    private final AgencyMapper agencyMapper;
    private final StationMapper stationMapper = new StationMapper();
    private final StopMapper stopMapper = new StopMapper();
    private final EntranceMapper entranceMapper = new EntranceMapper();
    private final PathwayNodeMapper pathwayNodeMapper = new PathwayNodeMapper();
    private final BoardingAreaMapper boardingAreaMapper = new BoardingAreaMapper();
    private final LocationMapper locationMapper = new LocationMapper();
    private final LocationGroupMapper locationGroupMapper = new LocationGroupMapper(this.stopMapper, this.locationMapper);
    private final FareAttributeMapper fareAttributeMapper = new FareAttributeMapper();
    private final ServiceCalendarDateMapper serviceCalendarDateMapper = new ServiceCalendarDateMapper();
    private final FeedInfoMapper feedInfoMapper;
    private final ShapePointMapper shapePointMapper = new ShapePointMapper();
    private final ServiceCalendarMapper serviceCalendarMapper = new ServiceCalendarMapper();
    private final PathwayMapper pathwayMapper = new PathwayMapper(this.stopMapper, this.entranceMapper, this.pathwayNodeMapper, this.boardingAreaMapper);
    private final RouteMapper routeMapper;
    private final TripMapper tripMapper;
    private final BookingRuleMapper bookingRuleMapper;
    private final StopTimeMapper stopTimeMapper;
    private final FrequencyMapper frequencyMapper;
    private final FareRuleMapper fareRuleMapper;
    private final DataImportIssueStore issueStore;
    private final GtfsRelationalDao data;
    private final OtpTransitServiceBuilder builder = new OtpTransitServiceBuilder();

    public GTFSToOtpTransitServiceMapper(String feedId, DataImportIssueStore issueStore, GtfsRelationalDao data) {
        this.issueStore = issueStore;
        this.data = data;
        this.feedInfoMapper = new FeedInfoMapper(feedId);
        this.agencyMapper = new AgencyMapper(feedId);
        this.routeMapper = new RouteMapper(this.agencyMapper, issueStore);
        this.tripMapper = new TripMapper(this.routeMapper);
        this.bookingRuleMapper = new BookingRuleMapper();
        this.stopTimeMapper = new StopTimeMapper(this.stopMapper, this.locationMapper, this.locationGroupMapper, this.tripMapper, this.bookingRuleMapper);
        this.frequencyMapper = new FrequencyMapper(this.tripMapper);
        this.fareRuleMapper = new FareRuleMapper(this.routeMapper, this.fareAttributeMapper);
    }

    public OtpTransitServiceBuilder getBuilder() {
        return this.builder;
    }

    public void mapStopTripAndRouteDatantoBuilder() {
        this.builder.getAgenciesById().addAll(this.agencyMapper.map(this.data.getAllAgencies()));
        this.builder.getCalendarDates().addAll(this.serviceCalendarDateMapper.map(this.data.getAllCalendarDates()));
        this.builder.getCalendars().addAll(this.serviceCalendarMapper.map(this.data.getAllCalendars()));
        this.builder.getFareAttributes().addAll(this.fareAttributeMapper.map(this.data.getAllFareAttributes()));
        this.builder.getFareRules().addAll(this.fareRuleMapper.map(this.data.getAllFareRules()));
        this.builder.getFeedInfos().addAll(this.feedInfoMapper.map(this.data.getAllFeedInfos()));
        this.builder.getFrequencies().addAll(this.frequencyMapper.map(this.data.getAllFrequencies()));
        this.builder.getRoutes().addAll(this.routeMapper.map(this.data.getAllRoutes()));
        for (ShapePoint shapePoint : this.shapePointMapper.map(this.data.getAllShapePoints())) {
            this.builder.getShapePoints().put((Object)shapePoint.getShapeId(), (Object)shapePoint);
        }
        this.mapGtfsStopsToOtpTypes(this.data);
        this.builder.getLocations().addAll(this.locationMapper.map(this.data.getAllLocations()));
        this.builder.getLocationGroups().addAll(this.locationGroupMapper.map(this.data.getAllLocationGroups()));
        this.builder.getPathways().addAll(this.pathwayMapper.map(this.data.getAllPathways()));
        this.builder.getStopTimesSortedByTrip().addAll(this.stopTimeMapper.map(this.data.getAllStopTimes()));
        this.builder.getTripsById().addAll(this.tripMapper.map(this.data.getAllTrips()));
        this.mapAndAddTransfersToBuilder();
    }

    private void mapAndAddTransfersToBuilder() {
        TransferMapper transferMapper = new TransferMapper(this.routeMapper, this.stationMapper, this.stopMapper, this.tripMapper, this.builder.getStopTimesSortedByTrip());
        this.builder.getTransfers().addAll(transferMapper.map(this.data.getAllTransfers()));
    }

    private void mapGtfsStopsToOtpTypes(GtfsRelationalDao data) {
        StopToParentStationLinker stopToParentStationLinker = new StopToParentStationLinker(this.issueStore);
        for (org.onebusaway.gtfs.model.Stop it : data.getAllStops()) {
            if (it.getLocationType() == 0) {
                Stop stop = this.stopMapper.map(it);
                this.builder.getStops().add(stop);
                stopToParentStationLinker.addStationElement(stop, it.getParentStation());
                continue;
            }
            if (it.getLocationType() == 1) {
                Station station = this.stationMapper.map(it);
                this.builder.getStations().add(station);
                stopToParentStationLinker.addStation(station);
                continue;
            }
            if (it.getLocationType() == 2) {
                Entrance entrance = this.entranceMapper.map(it);
                this.builder.getEntrances().add(entrance);
                stopToParentStationLinker.addStationElement(entrance, it.getParentStation());
                continue;
            }
            if (it.getLocationType() == 3) {
                PathwayNode pathwayNode = this.pathwayNodeMapper.map(it);
                this.builder.getPathwayNodes().add(pathwayNode);
                stopToParentStationLinker.addStationElement(pathwayNode, it.getParentStation());
                continue;
            }
            if (it.getLocationType() != 4) continue;
            BoardingArea boardingArea = this.boardingAreaMapper.map(it);
            this.builder.getBoardingAreas().add(boardingArea);
            stopToParentStationLinker.addBoardingArea(boardingArea, it.getParentStation());
        }
        stopToParentStationLinker.link();
    }
}

