/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opentripplanner.gtfs.mapping.FareAttributeMapper;
import org.opentripplanner.gtfs.mapping.RouteMapper;
import org.opentripplanner.model.FareRule;
import org.opentripplanner.util.MapUtils;

class FareRuleMapper {
    private final RouteMapper routeMapper;
    private final FareAttributeMapper fareAttributeMapper;
    private Map<org.onebusaway.gtfs.model.FareRule, FareRule> mappedFareRules = new HashMap<org.onebusaway.gtfs.model.FareRule, FareRule>();

    FareRuleMapper(RouteMapper routeMapper, FareAttributeMapper fareAttributeMapper) {
        this.routeMapper = routeMapper;
        this.fareAttributeMapper = fareAttributeMapper;
    }

    Collection<FareRule> map(Collection<org.onebusaway.gtfs.model.FareRule> allFareRules) {
        return MapUtils.mapToList(allFareRules, this::map);
    }

    FareRule map(org.onebusaway.gtfs.model.FareRule orginal) {
        return orginal == null ? null : this.mappedFareRules.computeIfAbsent(orginal, this::doMap);
    }

    private FareRule doMap(org.onebusaway.gtfs.model.FareRule rhs) {
        FareRule lhs = new FareRule();
        lhs.setFare(this.fareAttributeMapper.map(rhs.getFare()));
        lhs.setRoute(this.routeMapper.map(rhs.getRoute()));
        lhs.setOriginId(rhs.getOriginId());
        lhs.setDestinationId(rhs.getDestinationId());
        lhs.setContainsId(rhs.getContainsId());
        return lhs;
    }
}

