/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.onebusaway.gtfs.model.Stop;
import org.opentripplanner.gtfs.mapping.StopMappingWrapper;
import org.opentripplanner.model.Entrance;
import org.opentripplanner.util.MapUtils;

class EntranceMapper {
    private Map<Stop, Entrance> mappedEntrances = new HashMap<Stop, Entrance>();

    EntranceMapper() {
    }

    Collection<Entrance> map(Collection<Stop> allEntrances) {
        return MapUtils.mapToList(allEntrances, this::map);
    }

    Entrance map(Stop orginal) {
        return orginal == null ? null : this.mappedEntrances.computeIfAbsent(orginal, this::doMap);
    }

    private Entrance doMap(Stop gtfsStop) {
        if (gtfsStop.getLocationType() != 2) {
            throw new IllegalArgumentException("Expected type 2, but got " + gtfsStop.getLocationType());
        }
        StopMappingWrapper base = new StopMappingWrapper(gtfsStop);
        return new Entrance(base.getId(), base.getName(), base.getCode(), base.getDescription(), base.getCoordinate(), base.getWheelchairBoarding(), base.getLevel());
    }
}

