/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.onebusaway.gtfs.model.Stop;
import org.opentripplanner.gtfs.mapping.StopMappingWrapper;
import org.opentripplanner.model.BoardingArea;
import org.opentripplanner.util.MapUtils;

class BoardingAreaMapper {
    static final String DEFAULT_NAME = "Boarding area";
    private final Map<Stop, BoardingArea> mappedBoardingAreas = new HashMap<Stop, BoardingArea>();

    BoardingAreaMapper() {
    }

    Collection<BoardingArea> map(Collection<Stop> allBoardingAreas) {
        return MapUtils.mapToList(allBoardingAreas, this::map);
    }

    BoardingArea map(Stop orginal) {
        return orginal == null ? null : this.mappedBoardingAreas.computeIfAbsent(orginal, this::doMap);
    }

    private BoardingArea doMap(Stop gtfsStop) {
        if (gtfsStop.getLocationType() != 4) {
            throw new IllegalArgumentException("Expected type 4, but got " + gtfsStop.getLocationType());
        }
        StopMappingWrapper base = new StopMappingWrapper(gtfsStop);
        return new BoardingArea(base.getId(), Objects.requireNonNullElse(base.getName(), DEFAULT_NAME), base.getCode(), base.getDescription(), base.getCoordinate(), base.getWheelchairBoarding(), base.getLevel());
    }
}

