/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.Trip;
import org.opentripplanner.model.BikeAccess;

class BikeAccessMapper {
    BikeAccessMapper() {
    }

    public static BikeAccess mapForTrip(Trip rhs) {
        return BikeAccessMapper.mapValues(rhs.getBikesAllowed(), rhs.getTripBikesAllowed());
    }

    public static BikeAccess mapForRoute(Route rhs) {
        return BikeAccessMapper.mapValues(rhs.getBikesAllowed(), rhs.getRouteBikesAllowed());
    }

    private static BikeAccess mapValues(int bikesAllowed, int legacyBikesAllowed) {
        if (bikesAllowed != 0) {
            switch (bikesAllowed) {
                case 1: {
                    return BikeAccess.ALLOWED;
                }
                case 2: {
                    return BikeAccess.NOT_ALLOWED;
                }
            }
            return BikeAccess.UNKNOWN;
        }
        if (legacyBikesAllowed != 0) {
            switch (legacyBikesAllowed) {
                case 1: {
                    return BikeAccess.NOT_ALLOWED;
                }
                case 2: {
                    return BikeAccess.ALLOWED;
                }
            }
            return BikeAccess.UNKNOWN;
        }
        return BikeAccess.UNKNOWN;
    }
}

