/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.onebusaway.gtfs.model.Agency;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.util.MapUtils;

class AgencyMapper {
    private final Map<Agency, org.opentripplanner.model.Agency> mappedAgencies = new HashMap<Agency, org.opentripplanner.model.Agency>();
    private String feedId;

    public AgencyMapper(String feedId) {
        this.feedId = feedId;
    }

    Collection<org.opentripplanner.model.Agency> map(Collection<Agency> agencies) {
        return MapUtils.mapToList(agencies, this::map);
    }

    org.opentripplanner.model.Agency map(Agency orginal) {
        return orginal == null ? null : this.mappedAgencies.computeIfAbsent(orginal, this::doMap);
    }

    private org.opentripplanner.model.Agency doMap(Agency rhs) {
        org.opentripplanner.model.Agency lhs = new org.opentripplanner.model.Agency(new FeedScopedId(this.feedId, rhs.getId()), rhs.getName(), rhs.getTimezone());
        lhs.setUrl(rhs.getUrl());
        lhs.setLang(rhs.getLang());
        lhs.setPhone(rhs.getPhone());
        lhs.setFareUrl(rhs.getFareUrl());
        lhs.setBrandingUrl(rhs.getBrandingUrl());
        return lhs;
    }
}

