/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs;

import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opentripplanner.common.geometry.SphericalDistanceLibrary;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.HopSpeedFast;
import org.opentripplanner.graph_builder.issues.HopSpeedSlow;
import org.opentripplanner.graph_builder.issues.HopZeroTime;
import org.opentripplanner.graph_builder.issues.NegativeDwellTime;
import org.opentripplanner.graph_builder.issues.NegativeHopTime;
import org.opentripplanner.graph_builder.issues.RepeatedStops;
import org.opentripplanner.model.Stop;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.TripStopTimes;
import org.opentripplanner.util.OTPFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepairStopTimesForEachTripOperation {
    private static final Logger LOG = LoggerFactory.getLogger(RepairStopTimesForEachTripOperation.class);
    private static final int SECONDS_IN_HOUR = 3600;
    private final TripStopTimes stopTimesByTrip;
    private DataImportIssueStore issueStore;

    public RepairStopTimesForEachTripOperation(TripStopTimes stopTimesByTrip, DataImportIssueStore issueStore) {
        this.stopTimesByTrip = stopTimesByTrip;
        this.issueStore = issueStore;
    }

    public void run() {
        int tripSize = this.stopTimesByTrip.size();
        int tripCount = 0;
        for (Trip trip : this.stopTimesByTrip.keys()) {
            TIntList removedStopSequences;
            if (++tripCount % 100000 == 0) {
                LOG.debug("Repair StopTimes for trips {}/{}", (Object)tripCount, (Object)tripSize);
            }
            ArrayList<StopTime> stopTimes = new ArrayList<StopTime>(this.stopTimesByTrip.get(trip));
            if (OTPFeature.FlexRouting.isOff()) {
                stopTimes.removeIf(st -> !(st.getStop() instanceof Stop));
            }
            if (!(removedStopSequences = this.removeRepeatedStops(stopTimes)).isEmpty()) {
                this.issueStore.add(new RepeatedStops(trip, removedStopSequences));
            }
            this.filterStopTimes(stopTimes);
            this.interpolateStopTimes(stopTimes);
            this.stopTimesByTrip.replace(trip, stopTimes);
        }
    }

    private TIntList removeRepeatedStops(List<StopTime> stopTimes) {
        StopTime prev = null;
        Iterator<StopTime> it = stopTimes.iterator();
        TIntArrayList stopSequencesRemoved = new TIntArrayList();
        while (it.hasNext()) {
            StopTime st = it.next();
            if (prev != null && prev.getStop().equals(st.getStop())) {
                if (prev.getArrivalTime() == -999) {
                    prev.setArrivalTime(st.getArrivalTime());
                }
                if (st.getDepartureTime() != -999) {
                    prev.setDepartureTime(st.getDepartureTime());
                }
                it.remove();
                stopSequencesRemoved.add(st.getStopSequence());
            }
            prev = st;
        }
        return stopSequencesRemoved;
    }

    private void filterStopTimes(List<StopTime> stopTimes) {
        if (stopTimes.size() < 2) {
            return;
        }
        StopTime st0 = stopTimes.get(0);
        if (!st0.isDepartureTimeSet() && st0.isArrivalTimeSet()) {
            st0.setDepartureTime(st0.getArrivalTime());
        }
        boolean hasTimepoints = false;
        for (StopTime stopTime : stopTimes) {
            if (stopTime.getTimepoint() != 1) continue;
            hasTimepoints = true;
            break;
        }
        if (!hasTimepoints) {
            st0.setTimepoint(1);
        }
        boolean midnightCrossed = false;
        for (int i = 1; i < stopTimes.size(); ++i) {
            int runningTime;
            boolean st1bogus = false;
            StopTime st1 = stopTimes.get(i);
            if (!hasTimepoints && (st1.isDepartureTimeSet() || st1.isArrivalTimeSet())) {
                st1.setTimepoint(1);
            }
            if (midnightCrossed) {
                if (st1.isDepartureTimeSet()) {
                    st1.setDepartureTime(st1.getDepartureTime() + 86400);
                }
                if (st1.isArrivalTimeSet()) {
                    st1.setArrivalTime(st1.getArrivalTime() + 86400);
                }
            }
            if (!st1.isDepartureTimeSet() && st1.isArrivalTimeSet()) {
                st1.setDepartureTime(st1.getArrivalTime());
            }
            if (!st1.isArrivalTimeSet() || !st1.isDepartureTimeSet()) continue;
            int dwellTime = st0.getDepartureTime() - st0.getArrivalTime();
            if (dwellTime < 0) {
                this.issueStore.add(new NegativeDwellTime(st0));
                if (st0.getArrivalTime() > 82800 && st0.getDepartureTime() < 3600) {
                    midnightCrossed = true;
                    st0.setDepartureTime(st0.getDepartureTime() + 86400);
                } else {
                    st0.setDepartureTime(st0.getArrivalTime());
                }
            }
            if ((runningTime = st1.getArrivalTime() - st0.getDepartureTime()) < 0) {
                this.issueStore.add(new NegativeHopTime(new StopTime(st0), new StopTime(st1)));
                midnightCrossed = true;
                if (st0.getDepartureTime() > 82800 && st1.getArrivalTime() < 3600) {
                    st1.setArrivalTime(st1.getArrivalTime() + 86400);
                } else {
                    st1.setArrivalTime(st0.getDepartureTime());
                }
            }
            double hopDistance = SphericalDistanceLibrary.fastDistance(st0.getStop().getCoordinate().asJtsCoordinate(), st1.getStop().getCoordinate().asJtsCoordinate());
            double hopSpeed = hopDistance / (double)runningTime;
            if (st0.getArrivalTime() == st1.getArrivalTime() || st0.getDepartureTime() == st1.getDepartureTime()) {
                LOG.trace("{} {}", (Object)st0, (Object)st1);
                this.issueStore.add(new HopZeroTime((float)hopDistance, st1.getTrip(), st1.getStopSequence()));
                st1bogus = true;
            } else if (hopSpeed > 45.0) {
                this.issueStore.add(new HopSpeedFast((float)hopSpeed, (float)hopDistance, st0.getTrip(), st0.getStopSequence()));
            } else if (hopSpeed < 0.1) {
                this.issueStore.add(new HopSpeedSlow((float)hopSpeed, (float)hopDistance, st0.getTrip(), st0.getStopSequence()));
            }
            if (st1bogus) continue;
            st0 = st1;
        }
    }

    private void interpolateStopTimes(List<StopTime> stopTimes) {
        int lastStop = stopTimes.size() - 1;
        int numInterpStops = -1;
        int departureTime = -1;
        int prevDepartureTime = -1;
        int interpStep = 0;
        for (int i = 0; i < lastStop; ++i) {
            int j;
            StopTime st0 = stopTimes.get(i);
            prevDepartureTime = departureTime;
            departureTime = st0.getDepartureTime();
            if (st0.isDepartureTimeSet() && st0.isArrivalTimeSet() || FlexTrip.isFlexStop(st0.getStop())) continue;
            StopTime st = null;
            for (j = i + 1; !(j >= lastStop + 1 || (st = stopTimes.get(j)).isDepartureTimeSet() && st.getDepartureTime() != departureTime || st.isArrivalTimeSet() && st.getArrivalTime() != departureTime); ++j) {
            }
            if (j == lastStop + 1) {
                throw new RuntimeException("Could not interpolate arrival/departure time on stop " + i + " (missing final stop time) on trip " + st0.getTrip());
            }
            numInterpStops = j - i;
            int arrivalTime = st.isArrivalTimeSet() ? st.getArrivalTime() : st.getDepartureTime();
            interpStep = (arrivalTime - prevDepartureTime) / (numInterpStops + 1);
            if (interpStep < 0) {
                throw new RuntimeException("trip goes backwards for some reason");
            }
            for (j = i; j < i + numInterpStops; ++j) {
                departureTime = prevDepartureTime + interpStep * (j - i + 1);
                st = stopTimes.get(j);
                if (st.isArrivalTimeSet()) {
                    departureTime = st.getArrivalTime();
                } else {
                    st.setArrivalTime(departureTime);
                }
                if (st.isDepartureTimeSet()) continue;
                st.setDepartureTime(departureTime);
            }
            i = j - 1;
        }
    }
}

