/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs;

import java.io.File;
import java.io.IOException;
import org.onebusaway.gtfs.serialization.GtfsReader;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.gtfs.mapping.AgencyAndIdMapper;
import org.opentripplanner.gtfs.mapping.GTFSToOtpTransitServiceMapper;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.impl.OtpTransitServiceBuilder;

public class MockGtfs {
    private final org.onebusaway.gtfs.services.MockGtfs gtfsDelegate;

    private MockGtfs(org.onebusaway.gtfs.services.MockGtfs gtfsDelegate) {
        this.gtfsDelegate = gtfsDelegate;
    }

    public MockGtfs(File path) {
        this(new org.onebusaway.gtfs.services.MockGtfs(path));
    }

    public static MockGtfs create() throws IOException {
        return new MockGtfs(org.onebusaway.gtfs.services.MockGtfs.create());
    }

    public File getPath() {
        return this.gtfsDelegate.getPath();
    }

    public void putFile(String fileName, String content) {
        this.gtfsDelegate.putFile(fileName, content);
    }

    public void putFile(String fileName, File file) throws IOException {
        this.gtfsDelegate.putFile(fileName, file);
    }

    public void putLines(String fileName, String ... rows) {
        this.gtfsDelegate.putLines(fileName, rows);
    }

    public OtpTransitServiceBuilder read() throws IOException {
        return this.read(null);
    }

    public OtpTransitServiceBuilder read(GtfsReader reader) throws IOException {
        GTFSToOtpTransitServiceMapper mapper = new GTFSToOtpTransitServiceMapper("a0", new DataImportIssueStore(false), (GtfsRelationalDao)(reader == null ? this.gtfsDelegate.read() : this.gtfsDelegate.read(reader)));
        return mapper.getBuilder();
    }

    public void putMinimal() {
        this.gtfsDelegate.putMinimal();
    }

    public void putAgencies(int numberOfRows, String ... columns) {
        this.gtfsDelegate.putAgencies(numberOfRows, columns);
    }

    public void putDefaultAgencies() {
        this.gtfsDelegate.putDefaultAgencies();
    }

    public void putRoutes(int numberOfRows, String ... columns) {
        this.gtfsDelegate.putRoutes(numberOfRows, columns);
    }

    public void putDefaultRoutes() {
        this.gtfsDelegate.putDefaultRoutes();
    }

    public void putStops(int numberOfRows, String ... columns) {
        this.gtfsDelegate.putStops(numberOfRows, columns);
    }

    public void putDefaultStops() {
        this.gtfsDelegate.putDefaultStops();
    }

    public void putCalendars(int numberOfServiceIds, String ... columns) {
        this.gtfsDelegate.putCalendars(numberOfServiceIds, columns);
    }

    public void putDefaultCalendar() {
        this.gtfsDelegate.putDefaultCalendar();
    }

    public void putCalendarDates(String ... specs) {
        this.gtfsDelegate.putCalendarDates(specs);
    }

    public void putTrips(int numberOfRows, String routeIds, String serviceIds, String ... columns) {
        this.gtfsDelegate.putTrips(numberOfRows, routeIds, serviceIds, columns);
    }

    public void putDefaultTrips() {
        this.gtfsDelegate.putDefaultTrips();
    }

    public void putStopTimes(String tripIds, String stopIds) {
        this.gtfsDelegate.putStopTimes(tripIds, stopIds);
    }

    public void putDefaultStopTimes() {
        this.gtfsDelegate.putDefaultStopTimes();
    }

    public FeedScopedId id(String id) {
        return AgencyAndIdMapper.mapAgencyAndId(this.gtfsDelegate.id(id));
    }
}

