/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.GTFSModeNotSupported;
import org.opentripplanner.graph_builder.issues.TripDegenerate;
import org.opentripplanner.graph_builder.issues.TripUndefinedService;
import org.opentripplanner.model.Direction;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.Frequency;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.StopPattern;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.model.impl.OtpTransitServiceBuilder;
import org.opentripplanner.routing.trippattern.Deduplicator;
import org.opentripplanner.routing.trippattern.FrequencyEntry;
import org.opentripplanner.routing.trippattern.TripTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateTripPatternsOperation {
    private static final Logger LOG = LoggerFactory.getLogger(GenerateTripPatternsOperation.class);
    private final Map<String, Integer> tripPatternIdCounters = new HashMap<String, Integer>();
    private final OtpTransitServiceBuilder transitDaoBuilder;
    private final DataImportIssueStore issueStore;
    private final Deduplicator deduplicator;
    private final Set<FeedScopedId> calendarServiceIds;
    private final Multimap<StopPattern, TripPattern> tripPatterns;
    private final ListMultimap<Trip, Frequency> frequenciesForTrip = ArrayListMultimap.create();
    private int tripCount = 0;
    private int freqCount = 0;
    private int scheduledCount = 0;

    public GenerateTripPatternsOperation(OtpTransitServiceBuilder builder, DataImportIssueStore issueStore, Deduplicator deduplicator, Set<FeedScopedId> calendarServiceIds) {
        this.transitDaoBuilder = builder;
        this.issueStore = issueStore;
        this.deduplicator = deduplicator;
        this.calendarServiceIds = calendarServiceIds;
        this.tripPatterns = this.transitDaoBuilder.getTripPatterns();
    }

    public void run() {
        this.collectFrequencyByTrip();
        Collection<Trip> trips = this.transitDaoBuilder.getTripsById().values();
        int tripsSize = trips.size();
        for (Trip trip : trips) {
            if (++this.tripCount % 100000 == 0) {
                LOG.debug("build trip patterns {}/{}", (Object)this.tripCount, (Object)tripsSize);
            }
            this.buildTripPatternForTrip(trip);
        }
        LOG.info("Added {} frequency-based and {} single-trip timetable entries.", (Object)this.freqCount, (Object)this.scheduledCount);
    }

    public boolean hasFrequencyBasedTrips() {
        return this.freqCount > 0;
    }

    public boolean hasScheduledTrips() {
        return this.scheduledCount > 0;
    }

    private void collectFrequencyByTrip() {
        for (Frequency freq : this.transitDaoBuilder.getFrequencies()) {
            this.frequenciesForTrip.put((Object)freq.getTrip(), (Object)freq);
        }
    }

    private void buildTripPatternForTrip(Trip trip) {
        if (trip.getRoute().getMode() == null) {
            this.issueStore.add(new GTFSModeNotSupported(trip, Integer.toString(trip.getRoute().getGtfsType())));
            return;
        }
        if (!this.calendarServiceIds.contains(trip.getServiceId())) {
            this.issueStore.add(new TripUndefinedService(trip));
            return;
        }
        List<StopTime> stopTimes = this.transitDaoBuilder.getStopTimesSortedByTrip().get(trip);
        if (stopTimes.size() < 2) {
            this.issueStore.add(new TripDegenerate(trip));
            return;
        }
        StopPattern stopPattern = new StopPattern(stopTimes);
        Direction direction = trip.getDirection();
        TripPattern tripPattern = this.findOrCreateTripPattern(stopPattern, trip.getRoute(), direction);
        TripTimes tripTimes = new TripTimes(trip, stopTimes, this.deduplicator);
        List frequencies = this.frequenciesForTrip.get((Object)trip);
        if (frequencies != null && !frequencies.isEmpty()) {
            for (Frequency freq : frequencies) {
                tripPattern.add(new FrequencyEntry(freq, tripTimes));
                ++this.freqCount;
            }
        } else {
            tripPattern.add(tripTimes);
            ++this.scheduledCount;
        }
    }

    private TripPattern findOrCreateTripPattern(StopPattern stopPattern, Route route, Direction direction) {
        TripPattern tripPattern2;
        for (TripPattern tripPattern2 : this.tripPatterns.get((Object)stopPattern)) {
            if (!tripPattern2.getRoute().equals(route) || !tripPattern2.getDirection().equals((Object)direction)) continue;
            return tripPattern2;
        }
        FeedScopedId patternId = this.generateUniqueIdForTripPattern(route, direction.gtfsCode);
        tripPattern2 = new TripPattern(patternId, route, stopPattern);
        this.tripPatterns.put((Object)stopPattern, (Object)tripPattern2);
        return tripPattern2;
    }

    private FeedScopedId generateUniqueIdForTripPattern(Route route, int directionId) {
        FeedScopedId routeId = route.getId();
        String direction = directionId != -1 ? String.valueOf(directionId) : "";
        String key = routeId.getId() + ":" + direction;
        int counter = this.tripPatternIdCounters.getOrDefault(key, 0) + 1;
        this.tripPatternIdCounters.put(key, counter);
        String id = String.format("%s:%s:%02d", routeId.getId(), direction, counter);
        return new FeedScopedId(routeId.getFeedId(), id);
    }
}

