/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.services;

import org.locationtech.jts.geom.LineString;
import org.opentripplanner.graph_builder.services.StreetEdgeFactory;
import org.opentripplanner.routing.edgetype.AreaEdge;
import org.opentripplanner.routing.edgetype.AreaEdgeList;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.edgetype.StreetTraversalPermission;
import org.opentripplanner.routing.edgetype.StreetWithElevationEdge;
import org.opentripplanner.routing.vertextype.IntersectionVertex;
import org.opentripplanner.routing.vertextype.StreetVertex;
import org.opentripplanner.util.I18NString;

public class DefaultStreetEdgeFactory
implements StreetEdgeFactory {
    public boolean useElevationData = false;

    @Override
    public StreetEdge createEdge(IntersectionVertex startEndpoint, IntersectionVertex endEndpoint, LineString geometry, I18NString name, double length, StreetTraversalPermission permissions, boolean back) {
        StreetEdge pse = this.useElevationData ? new StreetWithElevationEdge((StreetVertex)startEndpoint, (StreetVertex)endEndpoint, geometry, name, length, permissions, back) : new StreetEdge((StreetVertex)startEndpoint, (StreetVertex)endEndpoint, geometry, name, length, permissions, back);
        return pse;
    }

    @Override
    public AreaEdge createAreaEdge(IntersectionVertex startEndpoint, IntersectionVertex endEndpoint, LineString geometry, I18NString name, double length, StreetTraversalPermission permissions, boolean back, AreaEdgeList area) {
        AreaEdge ae = new AreaEdge(startEndpoint, endEndpoint, geometry, name, length, permissions, back, area);
        return ae;
    }
}

