/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.vehicle;

import java.util.HashMap;
import java.util.List;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.services.GraphBuilderModule;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.vehicle_parking.VehicleParking;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingHelper;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingService;
import org.opentripplanner.updater.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VehicleParkingModule
implements GraphBuilderModule {
    private static final Logger LOG = LoggerFactory.getLogger(VehicleParkingModule.class);
    private DataSource<VehicleParking> dataSource;

    public void setDataSource(DataSource<VehicleParking> dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public void buildGraph(Graph graph, HashMap<Class<?>, Object> extra, DataImportIssueStore issueStore) {
        LOG.info("Building vehicle parking from static source...");
        VehicleParkingService service = graph.getService(VehicleParkingService.class, true);
        if (!this.dataSource.update()) {
            LOG.warn("No vehicle parks found from the data source.");
            return;
        }
        List<VehicleParking> vehicleParks = this.dataSource.getUpdates();
        for (VehicleParking vehicleParking : vehicleParks) {
            service.addVehicleParking(vehicleParking);
            VehicleParkingHelper.linkVehicleParkingToGraph(graph, vehicleParking);
        }
        LOG.info("Created " + vehicleParks.size() + " vehicle parks.");
    }

    @Override
    public void checkInputs() {
    }
}

