/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.shapefile;

import java.awt.RenderingHints;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opentripplanner.common.geometry.GeometryUtils;
import org.opentripplanner.common.model.P2;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.module.shapefile.ShapefileStreetSchema;
import org.opentripplanner.graph_builder.services.DefaultStreetEdgeFactory;
import org.opentripplanner.graph_builder.services.GraphBuilderModule;
import org.opentripplanner.graph_builder.services.StreetEdgeFactory;
import org.opentripplanner.graph_builder.services.shapefile.FeatureSourceFactory;
import org.opentripplanner.graph_builder.services.shapefile.SimpleFeatureConverter;
import org.opentripplanner.model.StreetNote;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.edgetype.StreetTraversalPermission;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.services.notes.StreetNotesService;
import org.opentripplanner.routing.vertextype.IntersectionVertex;
import org.opentripplanner.util.NonLocalizedString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShapefileStreetModule
implements GraphBuilderModule {
    private static Logger log = LoggerFactory.getLogger(ShapefileStreetModule.class);
    private FeatureSourceFactory featureSourceFactory;
    private ShapefileStreetSchema schema;
    public StreetEdgeFactory edgeFactory = new DefaultStreetEdgeFactory();

    public List<String> provides() {
        return Arrays.asList("streets");
    }

    public List<String> getPrerequisites() {
        return Collections.emptyList();
    }

    public void setFeatureSourceFactory(FeatureSourceFactory factory) {
        this.featureSourceFactory = factory;
    }

    public void setSchema(ShapefileStreetSchema schema) {
        this.schema = schema;
    }

    @Override
    public void buildGraph(Graph graph, HashMap<Class<?>, Object> extra, DataImportIssueStore issueStore) {
        try {
            FeatureSource<SimpleFeatureType, SimpleFeature> featureSource = this.featureSourceFactory.getFeatureSource();
            CoordinateReferenceSystem sourceCRS = featureSource.getInfo().getCRS();
            Hints hints = new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE);
            CRSAuthorityFactory factory = ReferencingFactoryFinder.getCRSAuthorityFactory((String)"EPSG", (Hints)hints);
            CoordinateReferenceSystem worldCRS = factory.createCoordinateReferenceSystem("EPSG:4326");
            Query query = new Query();
            query.setCoordinateSystem(sourceCRS);
            query.setCoordinateSystemReproject(worldCRS);
            FeatureCollection features = featureSource.getFeatures(query);
            features = featureSource.getFeatures(query);
            HashMap<String, HashMap<Coordinate, Integer>> intersectionNameToId = new HashMap<String, HashMap<Coordinate, Integer>>();
            SimpleFeatureConverter<String> streetIdConverter = this.schema.getIdConverter();
            SimpleFeatureConverter<String> streetNameConverter = this.schema.getNameConverter();
            SimpleFeatureConverter<P2<StreetTraversalPermission>> permissionConverter = this.schema.getPermissionConverter();
            SimpleFeatureConverter<String> noteConverter = this.schema.getNoteConverter();
            HashMap<Coordinate, IntersectionVertex> intersectionsByLocation = new HashMap<Coordinate, IntersectionVertex>();
            SimpleFeatureConverter<P2<Double>> safetyConverter = this.schema.getBicycleSafetyConverter();
            SimpleFeatureConverter<Boolean> slopeOverrideCoverter = this.schema.getSlopeOverrideConverter();
            SimpleFeatureConverter<Boolean> featureSelector = this.schema.getFeatureSelector();
            HashSet<CallSite> seen = new HashSet<CallSite>();
            ArrayList<SimpleFeature> featureList = new ArrayList<SimpleFeature>();
            FeatureIterator it2 = features.features();
            while (it2.hasNext()) {
                SimpleFeature feature = (SimpleFeature)it2.next();
                if (featureSelector != null && !featureSelector.convert(feature).booleanValue()) continue;
                featureList.add(feature);
            }
            it2.close();
            it2 = null;
            HashMap<Coordinate, TreeSet<String>> coordinateToStreetNames = this.getCoordinatesToStreetNames(featureList);
            for (SimpleFeature feature : featureList) {
                P2<Double> safetyFactors;
                String note;
                IntersectionVertex endIntersection;
                if (feature.getDefaultGeometry() == null) {
                    log.warn("feature has no geometry: " + feature.getIdentifier());
                    continue;
                }
                LineString geom = this.toLineString((Geometry)feature.getDefaultGeometry());
                String o = streetIdConverter.convert(feature);
                String label = o;
                if (o != null && seen.contains(label)) continue;
                seen.add((CallSite)((Object)label));
                String name = streetNameConverter.convert(feature);
                Coordinate[] coordinates = geom.getCoordinates();
                if (coordinates.length < 2) {
                    log.warn("Bad geometry for street with label " + label + " name " + name);
                    continue;
                }
                Coordinate startCoordinate = new Coordinate((double)Math.round(coordinates[0].x * 1048576.0) / 1048576.0, (double)Math.round(coordinates[0].y * 1048576.0) / 1048576.0);
                Coordinate endCoordinate = new Coordinate((double)Math.round(coordinates[coordinates.length - 1].x * 1048576.0) / 1048576.0, (double)Math.round(coordinates[coordinates.length - 1].y * 1048576.0) / 1048576.0);
                String startIntersectionName = this.getIntersectionName(coordinateToStreetNames, intersectionNameToId, startCoordinate);
                if (startIntersectionName == "null") {
                    log.warn("No intersection name for " + name);
                }
                String endIntersectionName = this.getIntersectionName(coordinateToStreetNames, intersectionNameToId, endCoordinate);
                IntersectionVertex startIntersection = (IntersectionVertex)intersectionsByLocation.get(startCoordinate);
                if (startIntersection == null) {
                    startIntersection = new IntersectionVertex(graph, startIntersectionName, startCoordinate.x, startCoordinate.y, new NonLocalizedString(startIntersectionName));
                    intersectionsByLocation.put(startCoordinate, startIntersection);
                }
                if ((endIntersection = (IntersectionVertex)intersectionsByLocation.get(endCoordinate)) == null) {
                    endIntersection = new IntersectionVertex(graph, endIntersectionName, endCoordinate.x, endCoordinate.y, new NonLocalizedString(endIntersectionName));
                    intersectionsByLocation.put(endCoordinate, endIntersection);
                }
                double length = 0.0;
                for (int i = 0; i < coordinates.length - 1; ++i) {
                    length += JTS.orthodromicDistance((Coordinate)coordinates[i], (Coordinate)coordinates[i + 1], (CoordinateReferenceSystem)worldCRS);
                }
                P2<StreetTraversalPermission> permissions = permissionConverter.convert(feature);
                StreetEdge street = this.edgeFactory.createEdge(startIntersection, endIntersection, geom, new NonLocalizedString(name), length, (StreetTraversalPermission)((Object)permissions.first), false);
                LineString reversed = geom.reverse();
                StreetEdge backStreet = this.edgeFactory.createEdge(endIntersection, startIntersection, reversed, new NonLocalizedString(name), length, (StreetTraversalPermission)((Object)permissions.second), true);
                backStreet.shareData(street);
                if (noteConverter != null && (note = noteConverter.convert(feature)) != null && note.length() > 0) {
                    StreetNote noteAlert = new StreetNote(note);
                    graph.streetNotesService.addStaticNote(street, noteAlert, StreetNotesService.ALWAYS_MATCHER);
                    graph.streetNotesService.addStaticNote(backStreet, noteAlert, StreetNotesService.ALWAYS_MATCHER);
                }
                boolean slopeOverride = slopeOverrideCoverter.convert(feature);
                street.setSlopeOverride(slopeOverride);
                backStreet.setSlopeOverride(slopeOverride);
                if (safetyConverter == null || (safetyFactors = safetyConverter.convert(feature)) == null) continue;
                street.setBicycleSafetyFactor(((Double)safetyFactors.first).floatValue());
                backStreet.setBicycleSafetyFactor(((Double)safetyFactors.second).floatValue());
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("error loading shapefile street data", ex);
        }
        finally {
            this.featureSourceFactory.cleanup();
        }
    }

    private HashMap<Coordinate, TreeSet<String>> getCoordinatesToStreetNames(List<SimpleFeature> features) {
        HashMap<Coordinate, TreeSet<String>> coordinateToStreets = new HashMap<Coordinate, TreeSet<String>>();
        SimpleFeatureConverter<String> streetNameConverter = this.schema.getNameConverter();
        SimpleFeatureConverter<Boolean> featureSelector = this.schema.getFeatureSelector();
        for (SimpleFeature feature : features) {
            if (featureSelector != null && !featureSelector.convert(feature).booleanValue()) continue;
            if (feature.getDefaultGeometry() == null) {
                log.warn("feature has no geometry: " + feature.getIdentifier());
                continue;
            }
            LineString geom = this.toLineString((Geometry)feature.getDefaultGeometry());
            for (Coordinate coord : geom.getCoordinates()) {
                String streetName;
                Coordinate rounded = new Coordinate((double)Math.round(coord.x * 1048576.0) / 1048576.0, (double)Math.round(coord.y * 1048576.0) / 1048576.0);
                TreeSet<String> streets = coordinateToStreets.get(rounded);
                if (streets == null) {
                    streets = new TreeSet();
                    coordinateToStreets.put(rounded, streets);
                }
                if ((streetName = streetNameConverter.convert(feature)) == null) {
                    throw new IllegalStateException("Unexpectedly got null for a street name for feature at " + coord);
                }
                streets.add(streetName);
            }
        }
        return coordinateToStreets;
    }

    private String getIntersectionName(HashMap<Coordinate, TreeSet<String>> coordinateToStreets, HashMap<String, HashMap<Coordinate, Integer>> intersectionNameToId, Coordinate coordinate) {
        TreeSet<String> streets = coordinateToStreets.get(coordinate);
        if (streets == null) {
            return "null";
        }
        String intersection = streets.first() + " at " + streets.last();
        HashMap<Object, Integer> possibleIntersections = intersectionNameToId.get(intersection);
        if (possibleIntersections == null) {
            possibleIntersections = new HashMap();
            possibleIntersections.put(coordinate, 1);
            intersectionNameToId.put(intersection, possibleIntersections);
            return intersection;
        }
        Integer index = possibleIntersections.get(coordinate);
        if (index == null) {
            int max = 0;
            for (Integer value : possibleIntersections.values()) {
                if (value <= max) continue;
                max = value;
            }
            possibleIntersections.put(coordinate, max + 1);
            index = max + 1;
        }
        if (index > 1) {
            intersection = intersection + " #" + possibleIntersections.get(coordinate);
        }
        return intersection;
    }

    private LineString toLineString(Geometry g) {
        if (g instanceof LineString) {
            return (LineString)g;
        }
        if (g instanceof MultiLineString) {
            MultiLineString ml = (MultiLineString)g;
            Coordinate[] coords = ml.getCoordinates();
            return GeometryUtils.getGeometryFactory().createLineString(coords);
        }
        throw new RuntimeException("found a geometry feature that's not a linestring: " + g);
    }

    @Override
    public void checkInputs() {
        this.featureSourceFactory.checkInputs();
    }
}

