/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.shapefile;

import java.io.File;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opentripplanner.graph_builder.services.shapefile.FeatureSourceFactory;

public class ShapefileFeatureSourceFactoryImpl
implements FeatureSourceFactory {
    private File path;
    private ShapefileDataStore dataStore;

    public ShapefileFeatureSourceFactoryImpl() {
    }

    public ShapefileFeatureSourceFactoryImpl(File path) {
        this.path = path;
    }

    public void setPath(File path) {
        this.path = path;
    }

    @Override
    public FeatureSource<SimpleFeatureType, SimpleFeature> getFeatureSource() {
        try {
            this.dataStore = new ShapefileDataStore(this.path.toURI().toURL());
            String[] typeNames = this.dataStore.getTypeNames();
            String typeName = typeNames[0];
            return this.dataStore.getFeatureSource(typeName);
        }
        catch (Exception ex) {
            throw new IllegalStateException("error creating feature source from shapefile: path=" + this.path, ex);
        }
    }

    @Override
    public void cleanup() {
        this.dataStore.dispose();
    }

    @Override
    public void checkInputs() {
        if (!this.path.canRead()) {
            throw new RuntimeException("Can't read Shapefile path: " + this.path);
        }
    }
}

