/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.shapefile;

import java.io.IOException;
import java.util.HashMap;
import org.geotools.data.FeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opentripplanner.graph_builder.services.shapefile.FeatureSourceFactory;
import org.opentripplanner.graph_builder.services.shapefile.SimpleFeatureConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinedFeatureConverter<T>
implements SimpleFeatureConverter<T> {
    private static Logger log = LoggerFactory.getLogger(JoinedFeatureConverter.class);
    private SimpleFeatureConverter<T> converter;
    private String joinedKey;
    private String mainKey;
    private FeatureSource<SimpleFeatureType, SimpleFeature> joinedSource;
    private HashMap<String, SimpleFeature> cache;

    public JoinedFeatureConverter() {
    }

    public JoinedFeatureConverter(String mainKey, String joinedKey, SimpleFeatureConverter<T> converter, FeatureSource<SimpleFeatureType, SimpleFeature> joinedSource) {
        this.mainKey = mainKey;
        this.joinedKey = joinedKey;
        this.converter = converter;
        this.joinedSource = joinedSource;
    }

    @Override
    public T convert(SimpleFeature feature) {
        this.ensureCached();
        String mainKeyValue = this.toHashableString(feature.getAttribute(this.mainKey));
        if (mainKeyValue == null) {
            log.warn("Feature " + feature.getID() + " has null value for its mainKey (" + this.mainKey + ")");
            return null;
        }
        SimpleFeature joinedFeature = this.cache.get(mainKeyValue);
        if (joinedFeature == null) {
            return null;
        }
        return this.converter.convert(joinedFeature);
    }

    private void ensureCached() {
        if (this.cache != null) {
            return;
        }
        this.cache = new HashMap();
        try {
            FeatureCollection features = this.joinedSource.getFeatures();
            FeatureIterator it = features.features();
            while (it.hasNext()) {
                SimpleFeature feature = (SimpleFeature)it.next();
                String joinedKeyValue = this.toHashableString(feature.getAttribute(this.joinedKey));
                if (joinedKeyValue != null) {
                    this.cache.put(joinedKeyValue, feature);
                    continue;
                }
                log.warn("Feature " + feature.getID() + " has null value for its joinedKey (" + this.joinedKey + ")");
            }
            it.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not cache values for joined shapefile", e);
        }
    }

    private String toHashableString(Object keyValue) {
        if (keyValue == null) {
            return null;
        }
        if (keyValue instanceof Number) {
            keyValue = ((Number)keyValue).doubleValue();
        }
        return keyValue.toString();
    }

    public void setConverter(SimpleFeatureConverter<T> converter) {
        this.converter = converter;
    }

    public void setJoinedKey(String joinedKey) {
        this.joinedKey = joinedKey;
    }

    public void setMainKey(String mainKey) {
        this.mainKey = mainKey;
    }

    public void setJoinedSourceFactory(FeatureSourceFactory factory) {
        this.joinedSource = factory.getFeatureSource();
    }

    public void setJoinedSource(FeatureSource<SimpleFeatureType, SimpleFeature> joinedSource) {
        this.joinedSource = joinedSource;
    }
}

