/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.shapefile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.opengis.feature.simple.SimpleFeature;
import org.opentripplanner.graph_builder.services.shapefile.SimpleFeatureConverter;

public class CompositeBooleanConverter
implements SimpleFeatureConverter<Boolean> {
    private Collection<SimpleFeatureConverter<Boolean>> converters = new ArrayList<SimpleFeatureConverter<Boolean>>();
    private boolean orPermissions = false;

    public CompositeBooleanConverter() {
    }

    public CompositeBooleanConverter(SimpleFeatureConverter<Boolean> ... converters) {
        this.converters = new ArrayList<SimpleFeatureConverter<Boolean>>(Arrays.asList(converters));
    }

    public boolean isOrPermissions() {
        return this.orPermissions;
    }

    public void setOrPermissions(boolean orPermissions) {
        this.orPermissions = orPermissions;
    }

    public void setConverters(Collection<SimpleFeatureConverter<Boolean>> converters) {
        this.converters = converters;
    }

    @Override
    public Boolean convert(SimpleFeature feature) {
        Boolean result = null;
        for (SimpleFeatureConverter<Boolean> converter : this.converters) {
            Boolean value = converter.convert(feature);
            if (result == null) {
                result = value;
                continue;
            }
            if (this.orPermissions) {
                result = result != false || value != false;
                continue;
            }
            result = result != false && value != false;
        }
        return result;
    }

    public void add(SimpleFeatureConverter<Boolean> converter) {
        this.converters.add(converter);
    }
}

