/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.shapefile;

import java.util.HashMap;
import java.util.Map;
import org.opengis.feature.simple.SimpleFeature;
import org.opentripplanner.common.model.P2;
import org.opentripplanner.graph_builder.module.shapefile.CaseBasedBicycleSafetyFeatureConverter;
import org.opentripplanner.graph_builder.services.shapefile.SimpleFeatureConverter;
import org.opentripplanner.routing.edgetype.StreetTraversalPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseBasedTraversalPermissionConverter
implements SimpleFeatureConverter<P2<StreetTraversalPermission>> {
    private static Logger log = LoggerFactory.getLogger(CaseBasedBicycleSafetyFeatureConverter.class);
    private String attributeName;
    private P2<StreetTraversalPermission> defaultPermission = P2.createPair(StreetTraversalPermission.ALL, StreetTraversalPermission.ALL);
    private Map<String, P2<StreetTraversalPermission>> _permissions = new HashMap<String, P2<StreetTraversalPermission>>();

    public CaseBasedTraversalPermissionConverter() {
    }

    public CaseBasedTraversalPermissionConverter(String attributeName) {
        this.attributeName = attributeName;
    }

    public CaseBasedTraversalPermissionConverter(String attributeName, StreetTraversalPermission defaultPermission) {
        this.attributeName = attributeName;
        this.defaultPermission = P2.createPair(defaultPermission, defaultPermission);
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public void setDefaultPermission(StreetTraversalPermission permission) {
        this.defaultPermission = P2.createPair(permission, permission);
    }

    public void setPermissions(Map<String, String> permissions) {
        for (Map.Entry<String, String> entry : permissions.entrySet()) {
            String attributeValue = entry.getKey();
            String perms = entry.getValue();
            String[] tokens = perms.split(",");
            if (tokens.length != 2) {
                throw new IllegalArgumentException("invalid street traversal permissions: " + perms);
            }
            StreetTraversalPermission forward = StreetTraversalPermission.valueOf(tokens[0]);
            StreetTraversalPermission reverse = StreetTraversalPermission.valueOf(tokens[1]);
            this.addPermission(attributeValue, forward, reverse);
        }
    }

    public void addPermission(String attributeValue, StreetTraversalPermission forward, StreetTraversalPermission reverse) {
        this._permissions.put(attributeValue, P2.createPair(forward, reverse));
    }

    @Override
    public P2<StreetTraversalPermission> convert(SimpleFeature feature) {
        if (this.attributeName == null) {
            return this.defaultPermission;
        }
        Object key = feature.getAttribute(this.attributeName);
        if (key == null) {
            return this.defaultPermission;
        }
        P2<StreetTraversalPermission> permission = this._permissions.get(key.toString());
        if (permission == null) {
            log.info("unexpected permission " + key.toString());
            return this.defaultPermission;
        }
        return permission;
    }
}

