/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.shapefile;

import java.util.HashMap;
import java.util.Map;
import org.opengis.feature.simple.SimpleFeature;
import org.opentripplanner.common.model.P2;
import org.opentripplanner.graph_builder.services.shapefile.SimpleFeatureConverter;

public class CaseBasedBicycleSafetyFeatureConverter
implements SimpleFeatureConverter<P2<Double>> {
    private String safetyAttributeName;
    private String directionAttributeName;
    private Map<String, Double> safetyFeatures = new HashMap<String, Double>();
    private Map<String, Integer> directions = new HashMap<String, Integer>();
    public static final P2<Double> oneone = new P2<Double>(1.0, 1.0);

    @Override
    public P2<Double> convert(SimpleFeature feature) {
        String directionKey;
        String safetyKey = feature.getAttribute(this.safetyAttributeName).toString();
        Double safetyFeature = this.safetyFeatures.get(safetyKey);
        if (safetyFeature == null) {
            return oneone;
        }
        int directionFeature = 3;
        if (this.directionAttributeName != null && (directionKey = feature.getAttribute(this.directionAttributeName).toString()) != null) {
            directionFeature = this.directions.get(directionKey.toString());
        }
        return new P2<Double>((directionFeature & 1) == 0 ? 1.0 : safetyFeature, (directionFeature & 2) == 0 ? 1.0 : safetyFeature);
    }

    public CaseBasedBicycleSafetyFeatureConverter(String safetyAttributeName, String directionAttributeName) {
        this.safetyAttributeName = safetyAttributeName;
        this.directionAttributeName = directionAttributeName;
    }

    public CaseBasedBicycleSafetyFeatureConverter() {
    }

    public void setSafetyAttributeName(String safetyAttributeName) {
        this.safetyAttributeName = safetyAttributeName;
    }

    public void setDirectionAttributeName(String directionAttributeName) {
        this.directionAttributeName = directionAttributeName;
    }

    public void setSafety(Map<String, String> safetyValues) {
        for (Map.Entry<String, String> entry : safetyValues.entrySet()) {
            String attributeValue = entry.getKey();
            String featureName = entry.getValue();
            Double safety = Double.valueOf(featureName);
            this.addSafety(attributeValue, safety);
        }
    }

    public void addSafety(String attributeValue, Double safety) {
        this.safetyFeatures.put(attributeValue, safety);
    }

    public void setDirection(Map<String, String> directionValues) {
        for (Map.Entry<String, String> entry : directionValues.entrySet()) {
            String attributeValue = entry.getKey();
            String featureName = entry.getValue();
            Integer direction = Integer.valueOf(featureName);
            this.addDirection(attributeValue, direction);
        }
    }

    public void addDirection(String attributeValue, Integer direction) {
        this.directions.put(attributeValue, direction);
    }
}

