/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.shapefile;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.opengis.feature.simple.SimpleFeature;
import org.opentripplanner.graph_builder.services.shapefile.SimpleFeatureConverter;

public class AttributeFeatureConverter<T>
implements SimpleFeatureConverter<T> {
    private String attributeName;
    private boolean decodeUTF8 = true;

    public AttributeFeatureConverter(String attributeName) {
        this.attributeName = attributeName;
    }

    public AttributeFeatureConverter() {
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    @Override
    public T convert(SimpleFeature feature) {
        Object value = feature.getAttribute(this.attributeName);
        if (value instanceof String && this.decodeUTF8) {
            String str = (String)value;
            Charset charset = Charset.forName("UTF-8");
            byte[] bytes = new byte[str.length()];
            str.getBytes(0, str.length(), bytes, 0);
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            value = charset.decode(bb).toString();
        }
        return (T)value;
    }

    public boolean isDecodeUTF8() {
        return this.decodeUTF8;
    }

    public void setDecodeUTF8(boolean decodeUTF8) {
        this.decodeUTF8 = decodeUTF8;
    }
}

