/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import org.opentripplanner.graph_builder.module.osm.DefaultWayPropertySetSource;
import org.opentripplanner.graph_builder.module.osm.FinlandWayPropertySetSource;
import org.opentripplanner.graph_builder.module.osm.GermanyWayPropertySetSource;
import org.opentripplanner.graph_builder.module.osm.NorwayWayPropertySetSource;
import org.opentripplanner.graph_builder.module.osm.UKWayPropertySetSource;
import org.opentripplanner.graph_builder.module.osm.WayPropertySet;
import org.opentripplanner.openstreetmap.model.OSMWithTags;
import org.opentripplanner.routing.core.intersection_model.IntersectionTraversalCostModel;

public interface WayPropertySetSource {
    public void populateProperties(WayPropertySet var1);

    public static WayPropertySetSource fromConfig(String type) {
        if ("default".equals(type)) {
            return new DefaultWayPropertySetSource();
        }
        if ("norway".equals(type)) {
            return new NorwayWayPropertySetSource();
        }
        if ("uk".equals(type)) {
            return new UKWayPropertySetSource();
        }
        if ("finland".equals(type)) {
            return new FinlandWayPropertySetSource();
        }
        if ("germany".equals(type)) {
            return new GermanyWayPropertySetSource();
        }
        throw new IllegalArgumentException(String.format("Unknown osmWayPropertySet: '%s'", type));
    }

    public DrivingDirection drivingDirection();

    public IntersectionTraversalCostModel getIntersectionTraversalCostModel();

    default public boolean isMotorVehicleThroughTrafficExplicitlyDisallowed(OSMWithTags way) {
        String motorVehicle = way.getTag("motor_vehicle");
        return this.isGeneralNoThroughTraffic(way) || "destination".equals(motorVehicle);
    }

    default public boolean isBicycleNoThroughTrafficExplicitlyDisallowed(OSMWithTags way) {
        String bicycle = way.getTag("bicycle");
        return this.isGeneralNoThroughTraffic(way) || "destination".equals(bicycle);
    }

    default public boolean isWalkNoThroughTrafficExplicitlyDisallowed(OSMWithTags way) {
        String foot = way.getTag("foot");
        return this.isGeneralNoThroughTraffic(way) || "destination".equals(foot);
    }

    default public boolean isGeneralNoThroughTraffic(OSMWithTags way) {
        String access = way.getTag("access");
        return "destination".equals(access) || "private".equals(access) || "customers".equals(access) || "delivery".equals(access);
    }

    public static enum DrivingDirection {
        RIGHT_HAND_TRAFFIC,
        LEFT_HAND_TRAFFIC;

    }
}

