/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opentripplanner.common.model.P2;
import org.opentripplanner.common.model.T2;
import org.opentripplanner.graph_builder.module.osm.CreativeNamer;
import org.opentripplanner.graph_builder.module.osm.CreativeNamerPicker;
import org.opentripplanner.graph_builder.module.osm.NotePicker;
import org.opentripplanner.graph_builder.module.osm.NoteProperties;
import org.opentripplanner.graph_builder.module.osm.OSMSpecifier;
import org.opentripplanner.graph_builder.module.osm.SlopeOverridePicker;
import org.opentripplanner.graph_builder.module.osm.SpeedPicker;
import org.opentripplanner.graph_builder.module.osm.WayProperties;
import org.opentripplanner.graph_builder.module.osm.WayPropertyPicker;
import org.opentripplanner.model.StreetNote;
import org.opentripplanner.openstreetmap.model.OSMWithTags;
import org.opentripplanner.routing.edgetype.StreetTraversalPermission;
import org.opentripplanner.routing.services.notes.NoteMatcher;
import org.opentripplanner.util.I18NString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WayPropertySet {
    private static Logger LOG = LoggerFactory.getLogger(WayPropertySet.class);
    private List<WayPropertyPicker> wayProperties;
    private List<CreativeNamerPicker> creativeNamers;
    private List<SlopeOverridePicker> slopeOverrides;
    private List<SpeedPicker> speedPickers;
    public Float defaultSpeed;
    private List<NotePicker> notes;
    private Pattern maxSpeedPattern;
    public WayProperties defaultProperties = new WayProperties();

    public WayPropertySet() {
        this.defaultProperties.setSafetyFeatures(new P2<Double>(1.0, 1.0));
        this.defaultProperties.setPermission(StreetTraversalPermission.ALL);
        this.defaultSpeed = Float.valueOf(11.2f);
        this.wayProperties = new ArrayList<WayPropertyPicker>();
        this.creativeNamers = new ArrayList<CreativeNamerPicker>();
        this.slopeOverrides = new ArrayList<SlopeOverridePicker>();
        this.speedPickers = new ArrayList<SpeedPicker>();
        this.notes = new ArrayList<NotePicker>();
        this.maxSpeedPattern = Pattern.compile("^([0-9][\\.0-9]*)\\s*(kmh|km/h|kmph|kph|mph|knots)?$");
    }

    public WayProperties getDataForWay(OSMWithTags way) {
        WayProperties leftResult = this.defaultProperties;
        WayProperties rightResult = this.defaultProperties;
        int bestLeftScore = 0;
        int bestRightScore = 0;
        ArrayList<WayProperties> leftMixins = new ArrayList<WayProperties>();
        ArrayList<WayProperties> rightMixins = new ArrayList<WayProperties>();
        for (WayPropertyPicker picker : this.wayProperties) {
            OSMSpecifier specifier = picker.getSpecifier();
            WayProperties wayProperties = picker.getProperties();
            P2<Integer> score = specifier.matchScores(way);
            int leftScore = (Integer)score.first;
            int rightScore = (Integer)score.second;
            if (picker.isSafetyMixin()) {
                if (leftScore > 0) {
                    leftMixins.add(wayProperties);
                }
                if (rightScore <= 0) continue;
                rightMixins.add(wayProperties);
                continue;
            }
            if (leftScore > bestLeftScore) {
                leftResult = wayProperties;
                bestLeftScore = leftScore;
            }
            if (rightScore <= bestRightScore) continue;
            rightResult = wayProperties;
            bestRightScore = rightScore;
        }
        WayProperties result = rightResult.clone();
        result.setSafetyFeatures(new P2<Double>((Double)rightResult.getSafetyFeatures().first, (Double)leftResult.getSafetyFeatures().second));
        if (leftMixins.size() > 0) {
            this.applyMixins(result, leftMixins, false);
        }
        if (rightMixins.size() > 0) {
            this.applyMixins(result, rightMixins, true);
        }
        if (!(bestLeftScore != 0 && bestRightScore != 0 || leftMixins.size() != 0 && rightMixins.size() != 0)) {
            String all_tags = this.dumpTags(way);
            LOG.debug("Used default permissions: " + all_tags);
        }
        return result;
    }

    private String dumpTags(OSMWithTags way) {
        String all_tags = null;
        Map<String, String> tags = way.getTags();
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String tag = key + "=" + value;
            if (all_tags == null) {
                all_tags = tag;
                continue;
            }
            all_tags = all_tags + "; " + tag;
        }
        return all_tags;
    }

    private void applyMixins(WayProperties result, List<WayProperties> mixins, boolean right) {
        P2<Double> safetyFeatures = result.getSafetyFeatures();
        double first = (Double)safetyFeatures.first;
        double second = (Double)safetyFeatures.second;
        for (WayProperties properties : mixins) {
            if (right) {
                second *= ((Double)properties.getSafetyFeatures().second).doubleValue();
                continue;
            }
            first *= ((Double)properties.getSafetyFeatures().first).doubleValue();
        }
        result.setSafetyFeatures(new P2<Double>(first, second));
    }

    public I18NString getCreativeNameForWay(OSMWithTags way) {
        CreativeNamer bestNamer = null;
        int bestScore = 0;
        for (CreativeNamerPicker picker : this.creativeNamers) {
            OSMSpecifier specifier = picker.specifier;
            CreativeNamer namer = picker.namer;
            int score = specifier.matchScore(way);
            if (score <= bestScore) continue;
            bestNamer = namer;
            bestScore = score;
        }
        if (bestNamer == null) {
            return null;
        }
        return bestNamer.generateCreativeName(way);
    }

    public float getCarSpeedForWay(OSMWithTags way, boolean back) {
        Float speed = null;
        if (way.hasTag("maxspeed:motorcar")) {
            speed = this.getMetersSecondFromSpeed(way.getTag("maxspeed:motorcar"));
        }
        if (speed == null && !back && way.hasTag("maxspeed:forward")) {
            speed = this.getMetersSecondFromSpeed(way.getTag("maxspeed:forward"));
        }
        if (speed == null && back && way.hasTag("maxspeed:reverse")) {
            speed = this.getMetersSecondFromSpeed(way.getTag("maxspeed:reverse"));
        }
        if (speed == null && way.hasTag("maxspeed:lanes")) {
            for (String lane : way.getTag("maxspeed:lanes").split("\\|")) {
                Float currentSpeed = this.getMetersSecondFromSpeed(lane);
                if (currentSpeed == null || speed != null && !(currentSpeed.floatValue() > speed.floatValue())) continue;
                speed = currentSpeed;
            }
        }
        if (way.hasTag("maxspeed") && speed == null) {
            speed = this.getMetersSecondFromSpeed(way.getTag("maxspeed"));
        }
        if (speed != null && (double)speed.floatValue() < 1.0E-4) {
            LOG.warn("Zero or negative automobile speed detected at {} based on OSM maxspeed tags; ignoring these tags", (Object)this);
        }
        if (speed != null && (double)speed.floatValue() > 1.0E-4) {
            return speed.floatValue();
        }
        int bestScore = 0;
        Float bestSpeed = null;
        for (SpeedPicker picker : this.speedPickers) {
            OSMSpecifier specifier = picker.specifier;
            int score = specifier.matchScore(way);
            if (score <= bestScore) continue;
            bestScore = score;
            bestSpeed = Float.valueOf(picker.speed);
        }
        if (bestSpeed != null) {
            return bestSpeed.floatValue();
        }
        return this.defaultSpeed.floatValue();
    }

    public Set<T2<StreetNote, NoteMatcher>> getNoteForWay(OSMWithTags way) {
        HashSet<T2<StreetNote, NoteMatcher>> out = new HashSet<T2<StreetNote, NoteMatcher>>();
        for (NotePicker picker : this.notes) {
            OSMSpecifier specifier = picker.specifier;
            NoteProperties noteProperties = picker.noteProperties;
            if (specifier.matchScore(way) <= 0) continue;
            out.add(noteProperties.generateNote(way));
        }
        if (out.size() == 0) {
            return null;
        }
        return out;
    }

    public boolean getSlopeOverride(OSMWithTags way) {
        boolean result = false;
        int bestScore = 0;
        for (SlopeOverridePicker picker : this.slopeOverrides) {
            OSMSpecifier specifier = picker.getSpecifier();
            int score = specifier.matchScore(way);
            if (score <= bestScore) continue;
            result = picker.getOverride();
            bestScore = score;
        }
        return result;
    }

    public void addProperties(OSMSpecifier spec, WayProperties properties, boolean mixin) {
        if (!mixin && spec.containsLogicalOr()) {
            throw new RuntimeException(String.format("The logical OR operator ('|') is only implemented for mixins. Spec %s", spec.toString()));
        }
        this.wayProperties.add(new WayPropertyPicker(spec, properties, mixin));
    }

    public void addProperties(OSMSpecifier spec, WayProperties properties) {
        this.wayProperties.add(new WayPropertyPicker(spec, properties, false));
    }

    public void addCreativeNamer(OSMSpecifier spec, CreativeNamer namer) {
        this.creativeNamers.add(new CreativeNamerPicker(spec, namer));
    }

    public void addNote(OSMSpecifier osmSpecifier, NoteProperties properties) {
        this.notes.add(new NotePicker(osmSpecifier, properties));
    }

    public void setSlopeOverride(OSMSpecifier spec, boolean override) {
        this.slopeOverrides.add(new SlopeOverridePicker(spec, override));
    }

    public boolean equals(Object o) {
        if (o instanceof WayPropertySet) {
            WayPropertySet other = (WayPropertySet)o;
            return this.defaultProperties.equals(other.defaultProperties) && this.wayProperties.equals(other.wayProperties) && this.creativeNamers.equals(other.creativeNamers) && this.slopeOverrides.equals(other.slopeOverrides) && this.notes.equals(other.notes);
        }
        return false;
    }

    public int hashCode() {
        return this.defaultProperties.hashCode() + this.wayProperties.hashCode() + this.creativeNamers.hashCode() + this.slopeOverrides.hashCode();
    }

    public void addSpeedPicker(SpeedPicker picker) {
        this.speedPickers.add(picker);
    }

    public Float getMetersSecondFromSpeed(String speed) {
        float metersSecond;
        float originalUnits;
        Matcher m = this.maxSpeedPattern.matcher(speed.trim());
        if (!m.matches()) {
            return null;
        }
        try {
            originalUnits = (float)Double.parseDouble(m.group(1));
        }
        catch (NumberFormatException e) {
            LOG.warn("Could not parse max speed {}", (Object)m.group(1));
            return null;
        }
        String units = m.group(2);
        if (units == null || units.equals("")) {
            units = "kmh";
        }
        if ((units = units.intern()) == "kmh" || units == "km/h" || units == "kmph" || units == "kph") {
            metersSecond = 0.277778f * originalUnits;
        } else if (units == "mph") {
            metersSecond = 0.446944f * originalUnits;
        } else if (units == "knots") {
            metersSecond = 0.514444f * originalUnits;
        } else {
            return null;
        }
        return Float.valueOf(metersSecond);
    }

    public void createNames(String spec, String patternKey) {
        String pattern = patternKey;
        CreativeNamer namer = new CreativeNamer(pattern);
        this.addCreativeNamer(new OSMSpecifier(spec), namer);
    }

    public void createNotes(String spec, String patternKey, NoteMatcher matcher) {
        String pattern = patternKey;
        NoteProperties properties = new NoteProperties(pattern, matcher);
        this.addNote(new OSMSpecifier(spec), properties);
    }

    public void setProperties(String spec, StreetTraversalPermission permission) {
        this.setProperties(spec, permission, 1.0, 1.0);
    }

    public void setProperties(String spec, StreetTraversalPermission permission, double safety, double safetyBack) {
        this.setProperties(spec, permission, safety, safetyBack, false);
    }

    public void setProperties(String spec, StreetTraversalPermission permission, double safety, double safetyBack, boolean mixin) {
        WayProperties properties = new WayProperties();
        properties.setPermission(permission);
        properties.setSafetyFeatures(new P2<Double>(safety, safetyBack));
        this.addProperties(new OSMSpecifier(spec), properties, mixin);
    }

    public void setCarSpeed(String spec, float speed) {
        SpeedPicker picker = new SpeedPicker();
        picker.specifier = new OSMSpecifier(spec);
        picker.speed = speed;
        this.addSpeedPicker(picker);
    }

    public List<WayPropertyPicker> getWayProperties() {
        return Collections.unmodifiableList(this.wayProperties);
    }
}

