/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opentripplanner.openstreetmap.model.OSMWithTags;

public class TemplateLibrary {
    private static final Pattern patternMatcher = Pattern.compile("\\{(.*?)\\}");

    public static String generate(String pattern, OSMWithTags way) {
        if (pattern == null) {
            return null;
        }
        StringBuffer gen_name = new StringBuffer();
        Matcher matcher = patternMatcher.matcher(pattern);
        int lastEnd = 0;
        while (matcher.find()) {
            gen_name.append(pattern, lastEnd, matcher.start());
            lastEnd = matcher.end();
            String key = matcher.group(1);
            String tag = way.getTag(key);
            if (tag == null) continue;
            gen_name.append(tag);
        }
        gen_name.append(pattern, lastEnd, pattern.length());
        return gen_name.toString();
    }

    public static Map<String, String> generateI18N(String pattern, OSMWithTags way) {
        if (pattern == null) {
            return null;
        }
        HashMap<String, StringBuffer> i18n = new HashMap<String, StringBuffer>();
        i18n.put(null, new StringBuffer());
        Matcher matcher = patternMatcher.matcher(pattern);
        int lastEnd = 0;
        while (matcher.find()) {
            String defTag;
            for (StringBuffer sb : i18n.values()) {
                sb.append(pattern, lastEnd, matcher.start());
            }
            lastEnd = matcher.end();
            String defKey = matcher.group(1);
            Map<String, String> i18nTags = way.getTagsByPrefix(defKey);
            if (i18nTags != null) {
                for (Map.Entry<String, String> kv : i18nTags.entrySet()) {
                    String lang;
                    if (kv.getKey().equals(defKey) || i18n.containsKey(lang = kv.getKey().substring(defKey.length() + 1))) continue;
                    i18n.put(lang, new StringBuffer((CharSequence)i18n.get(null)));
                }
            }
            if ((defTag = way.getTag(defKey)) == null && i18nTags != null && i18nTags.size() != 0) {
                defTag = i18nTags.values().iterator().next();
            }
            for (String lang : i18n.keySet()) {
                String i18nTag = way.getTag((String)defKey + ":" + lang);
                ((StringBuffer)i18n.get(lang)).append(i18nTag != null ? i18nTag : (defTag != null ? defTag : ""));
            }
        }
        for (StringBuffer sb : i18n.values()) {
            sb.append(pattern, lastEnd, pattern.length());
        }
        HashMap<String, String> out = new HashMap<String, String>(i18n.size());
        for (Map.Entry kv : i18n.entrySet()) {
            out.put((String)kv.getKey(), ((StringBuffer)kv.getValue()).toString());
        }
        return out;
    }
}

