/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import gnu.trove.list.TLongList;
import gnu.trove.map.TLongObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.opentripplanner.api.resource.CoordinateArrayListSequence;
import org.opentripplanner.common.geometry.GeometryUtils;
import org.opentripplanner.openstreetmap.model.OSMNode;

public class Ring {
    public List<OSMNode> nodes;
    private Coordinate[] geometry;
    private List<Ring> holes = new ArrayList<Ring>();
    public Polygon jtsPolygon;

    public Ring(List<OSMNode> osmNodes) {
        ArrayList<Coordinate> vertices = new ArrayList<Coordinate>();
        this.nodes = osmNodes;
        for (OSMNode node : osmNodes) {
            Coordinate point = new Coordinate(node.lon, node.lat);
            vertices.add(point);
        }
        this.geometry = vertices.toArray(new Coordinate[0]);
        if (Orientation.isCCW((CoordinateSequence)new CoordinateArrayListSequence(new ArrayList<Coordinate>(List.of(this.geometry))))) {
            this.nodes = new ArrayList<OSMNode>(this.nodes);
            Collections.reverse(this.nodes);
            ArrayUtils.reverse((Object[])this.geometry);
        }
        this.jtsPolygon = this.calculateJtsPolygon();
    }

    public Ring(TLongList osmNodes, TLongObjectMap<OSMNode> _nodes) {
        ArrayList<Coordinate> vertices = new ArrayList<Coordinate>();
        this.nodes = new ArrayList<OSMNode>(osmNodes.size());
        osmNodes.forEach(nodeId -> {
            OSMNode node = (OSMNode)_nodes.get(nodeId);
            Coordinate point = new Coordinate(node.lon, node.lat);
            this.nodes.add(node);
            vertices.add(point);
            return true;
        });
        if (Orientation.isCCW((CoordinateSequence)new CoordinateArrayListSequence(vertices))) {
            Collections.reverse(this.nodes);
            Collections.reverse(vertices);
        }
        this.geometry = vertices.toArray(new Coordinate[0]);
        this.jtsPolygon = this.calculateJtsPolygon();
    }

    public List<Ring> getHoles() {
        return this.holes;
    }

    public void addHole(Ring hole) {
        this.holes.add(hole);
        this.jtsPolygon = this.calculateJtsPolygon();
    }

    boolean isNodeConvex(int i) {
        int n = this.nodes.size() - 1;
        OSMNode cur = this.nodes.get(i);
        OSMNode prev = this.nodes.get((i + n - 1) % n);
        OSMNode next = this.nodes.get((i + 1) % n);
        return (cur.lon - prev.lon) * (next.lat - cur.lat) - (cur.lat - prev.lat) * (next.lon - cur.lon) > 0.0;
    }

    private Polygon calculateJtsPolygon() {
        LinearRing shell;
        GeometryFactory factory = GeometryUtils.getGeometryFactory();
        try {
            shell = factory.createLinearRing(this.geometry);
        }
        catch (IllegalArgumentException e) {
            throw new RingConstructionException();
        }
        ArrayList<Polygon> polygonHoles = new ArrayList<Polygon>();
        for (Ring ring : this.holes) {
            LinearRing linearRing = factory.createLinearRing(ring.geometry);
            Polygon polygon = factory.createPolygon(linearRing, new LinearRing[0]);
            Iterator it = polygonHoles.iterator();
            while (it.hasNext()) {
                Polygon otherHole = (Polygon)it.next();
                if (!otherHole.relate((Geometry)polygon, "F***1****")) continue;
                polygon = (Polygon)polygon.union((Geometry)otherHole);
                it.remove();
            }
            polygonHoles.add(polygon);
        }
        ArrayList<LinearRing> lrholelist = new ArrayList<LinearRing>(polygonHoles.size());
        for (Polygon hole : polygonHoles) {
            Geometry boundary = hole.getBoundary();
            if (boundary instanceof LinearRing) {
                lrholelist.add((LinearRing)boundary);
                continue;
            }
            LinearRing line = hole.getExteriorRing();
            LinearRing ring = factory.createLinearRing(line.getCoordinates());
            lrholelist.add(ring);
        }
        LinearRing[] linearRingArray = lrholelist.toArray(new LinearRing[lrholelist.size()]);
        return factory.createPolygon(shell, linearRingArray);
    }

    public static class RingConstructionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }
}

