/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import org.opentripplanner.graph_builder.services.osm.CustomNamer;
import org.opentripplanner.openstreetmap.model.OSMWithTags;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.util.NonLocalizedString;

public class PortlandCustomNamer
implements CustomNamer {
    public static String[] STREET_SUFFIXES = new String[]{"Avenue", "Street", "Drive", "Court", "Highway", "Lane", "Way", "Place", "Road", "Boulevard", "Alley"};
    public static String[] PATH_WORDS = new String[]{"Trail", "Trails", "Greenway", "Esplanade", "Spur", "Loop"};
    private HashSet<StreetEdge> nameByOrigin = new HashSet();
    private HashSet<StreetEdge> nameByDestination = new HashSet();

    @Override
    public String name(OSMWithTags way, String defaultName) {
        if (!way.hasTag("name")) {
            return defaultName;
        }
        if ((way.isTag("footway", "sidewalk").booleanValue() || way.isTag("path", "sidewalk").booleanValue()) && this.isStreet(defaultName)) {
            return this.sidewalk(defaultName);
        }
        String highway = way.getTag("highway");
        if (("footway".equals(highway) || "path".equals(highway) || "cycleway".equals(highway)) && !this.isObviouslyPath(defaultName)) {
            return this.path(defaultName);
        }
        if ("pedestrian".equals(highway)) {
            return this.pedestrianStreet(defaultName);
        }
        return defaultName;
    }

    private boolean isStreet(String defaultName) {
        for (String suffix : STREET_SUFFIXES) {
            if (!defaultName.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    private boolean isObviouslyPath(String defaultName) {
        for (String word : PATH_WORDS) {
            if (!defaultName.contains(word)) continue;
            return true;
        }
        return false;
    }

    private String path(String name) {
        if (!((String)name).toLowerCase().contains("path")) {
            name = (String)name + " (path)".intern();
        }
        return name;
    }

    private String pedestrianStreet(String name) {
        if (!((String)name).toLowerCase().contains("pedestrian street")) {
            name = (String)name + " (pedestrian street)".intern();
        }
        return name;
    }

    private String sidewalk(String name) {
        if (!((String)name).toLowerCase().contains("sidewalk")) {
            name = (String)name + " (sidewalk)".intern();
        }
        return name;
    }

    @Override
    public void nameWithEdge(OSMWithTags way, StreetEdge edge) {
        if (!edge.hasBogusName()) {
            return;
        }
        String highway = way.getTag("highway");
        if ("motorway_link".equals(highway) || "trunk_link".equals(highway)) {
            if (edge.isBack()) {
                this.nameByDestination.add(edge);
            } else {
                this.nameByOrigin.add(edge);
            }
        } else if ("secondary_link".equals(highway) || "primary_link".equals(highway) || "tertiary_link".equals(highway)) {
            if (edge.isBack()) {
                this.nameByOrigin.add(edge);
            } else {
                this.nameByDestination.add(edge);
            }
        }
    }

    @Override
    public void postprocess(Graph graph) {
        for (StreetEdge e : this.nameByOrigin) {
            this.nameAccordingToOrigin(graph, e, 15);
        }
        for (StreetEdge e : this.nameByDestination) {
            this.nameAccordingToDestination(graph, e, 15);
        }
    }

    @Override
    public void configure(JsonNode config) {
    }

    private String nameAccordingToDestination(Graph graph, StreetEdge e, int maxDepth) {
        if (maxDepth == 0) {
            return null;
        }
        Vertex toVertex = e.getToVertex();
        for (StreetEdge out : Iterables.filter(toVertex.getOutgoing(), StreetEdge.class)) {
            String name;
            if (out.hasBogusName()) {
                name = this.nameAccordingToDestination(graph, out, maxDepth - 1);
                if (name == null) continue;
                e.setName(new NonLocalizedString(name));
                return name;
            }
            name = out.getDefaultName();
            e.setName(new NonLocalizedString(name));
            return name;
        }
        return null;
    }

    private String nameAccordingToOrigin(Graph graph, StreetEdge e, int maxDepth) {
        if (maxDepth == 0) {
            return null;
        }
        Vertex fromVertex = e.getFromVertex();
        for (StreetEdge in : Iterables.filter(fromVertex.getIncoming(), StreetEdge.class)) {
            String name;
            if (in.hasBogusName()) {
                name = this.nameAccordingToOrigin(graph, in, maxDepth - 1);
                if (name == null) continue;
                e.setName(new NonLocalizedString(name));
                return name;
            }
            name = in.getDefaultName();
            e.setName(new NonLocalizedString(name));
            return name;
        }
        return null;
    }
}

