/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.opentripplanner.common.model.P2;
import org.opentripplanner.openstreetmap.model.OSMWithTags;

public class OSMSpecifier {
    private List<P2<String>> logicalANDPairs = new ArrayList<P2<String>>(3);
    private List<P2<String>> logicalORPairs = new ArrayList<P2<String>>(3);

    public OSMSpecifier(String spec) {
        if (spec.contains("|") && spec.contains(";")) {
            throw new RuntimeException(String.format("You cannot mix logical AND (';') and logical OR ('|') in same OSM spec: '%s'", spec));
        }
        if (spec.contains("|") && spec.contains("*")) {
            throw new RuntimeException(String.format("You cannot mix logical OR ('|') and wildcards ('*') in the same OSM spec: '%s'", spec));
        }
        if (spec.contains("|")) {
            this.logicalORPairs = this.getPairsFromString(spec, "\\|");
        } else {
            this.logicalANDPairs = this.getPairsFromString(spec, ";");
        }
    }

    private List<P2<String>> getPairsFromString(String spec, String separator) {
        return Arrays.stream(spec.split(separator)).filter(p -> !p.isEmpty()).map(pair -> {
            String[] kv = pair.split("=");
            return new P2<String>(kv[0], kv[1]);
        }).collect(Collectors.toList());
    }

    public P2<Integer> matchScores(OSMWithTags match) {
        if (!this.logicalANDPairs.isEmpty()) {
            return this.computeANDScore(match);
        }
        return this.computeORScore(match);
    }

    private P2<Integer> computeORScore(OSMWithTags match) {
        boolean oneOfORPairMatches = this.logicalORPairs.stream().anyMatch(pair -> match.isTag((String)pair.first, (String)pair.second));
        if (oneOfORPairMatches) {
            return new P2<Integer>(1, 1);
        }
        return new P2<Integer>(0, 0);
    }

    private P2<Integer> computeANDScore(OSMWithTags match) {
        int leftScore = 0;
        int rightScore = 0;
        int leftMatches = 0;
        int rightMatches = 0;
        for (P2<String> pair : this.logicalANDPairs) {
            String tag = ((String)pair.first).toLowerCase();
            String value = ((String)pair.second).toLowerCase();
            String leftMatchValue = match.getTag(tag + ":left");
            String rightMatchValue = match.getTag(tag + ":right");
            String matchValue = match.getTag(tag);
            if (leftMatchValue == null) {
                leftMatchValue = matchValue;
            }
            if (rightMatchValue == null) {
                rightMatchValue = matchValue;
            }
            int leftTagScore = this.getTagScore(value, leftMatchValue);
            leftScore += leftTagScore;
            if (leftTagScore > 0) {
                ++leftMatches;
            }
            int rightTagScore = this.getTagScore(value, rightMatchValue);
            rightScore += rightTagScore;
            if (rightTagScore <= 0) continue;
            ++rightMatches;
        }
        int allMatchLeftBonus = leftMatches == this.logicalANDPairs.size() ? 10 : 0;
        int allMatchRightBonus = rightMatches == this.logicalANDPairs.size() ? 10 : 0;
        return new P2<Integer>(leftScore += allMatchLeftBonus, rightScore += allMatchRightBonus);
    }

    public int matchScore(OSMWithTags match) {
        int score = 0;
        int matches = 0;
        for (P2<String> pair : this.logicalANDPairs) {
            String tag = ((String)pair.first).toLowerCase();
            String value = ((String)pair.second).toLowerCase();
            String matchValue = match.getTag(tag);
            int tagScore = this.getTagScore(value, matchValue);
            score += tagScore;
            if (tagScore <= 0) continue;
            ++matches;
        }
        return score += matches == this.logicalANDPairs.size() ? 10 : 0;
    }

    private int getTagScore(String value, String matchValue) {
        if (value.equals("*") && matchValue != null) {
            return 1;
        }
        if (value.equals(matchValue)) {
            return 100;
        }
        if (value.contains(":")) {
            if ((value = value.split(":", 2)[0]).equals(matchValue)) {
                return 75;
            }
            return 0;
        }
        return 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (P2<String> pair : this.logicalANDPairs) {
            builder.append((String)pair.first);
            builder.append("=");
            builder.append((String)pair.second);
            builder.append(";");
        }
        for (P2<String> pair : this.logicalORPairs) {
            builder.append((String)pair.first);
            builder.append("=");
            builder.append((String)pair.second);
            builder.append("|");
        }
        return builder.toString();
    }

    public boolean containsLogicalOr() {
        return !this.logicalORPairs.isEmpty();
    }
}

