/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import org.opentripplanner.common.model.P2;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.ConflictingBikeTags;
import org.opentripplanner.openstreetmap.model.OSMWay;
import org.opentripplanner.openstreetmap.model.OSMWithTags;
import org.opentripplanner.routing.edgetype.StreetTraversalPermission;
import org.opentripplanner.routing.graph.Graph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSMFilter {
    private static Logger LOG = LoggerFactory.getLogger(OSMFilter.class);

    static boolean isWayRoutable(OSMWithTags way) {
        if (!OSMFilter.isOsmEntityRoutable(way)) {
            return false;
        }
        String highway = way.getTag("highway");
        if (highway != null && (highway.equals("conveyer") || highway.equals("proposed") || highway.equals("construction") || highway.equals("razed") || highway.equals("raceway") || highway.equals("unbuilt"))) {
            return false;
        }
        if (way.isGeneralAccessDenied()) {
            return way.isMotorcarExplicitlyAllowed() || way.isBicycleExplicitlyAllowed() || way.isPedestrianExplicitlyAllowed() || way.isMotorVehicleExplicitlyAllowed();
        }
        return true;
    }

    public static boolean isOsmEntityRoutable(OSMWithTags osmEntity) {
        if (osmEntity.hasTag("highway")) {
            return true;
        }
        if (osmEntity.isTag("public_transport", "platform").booleanValue() || osmEntity.isTag("railway", "platform").booleanValue()) {
            return !"tourism".equals(osmEntity.getTag("usage"));
        }
        return false;
    }

    public static StreetTraversalPermission getPermissionsForEntity(OSMWithTags entity, StreetTraversalPermission def) {
        StreetTraversalPermission permission = null;
        if (entity.isGeneralAccessDenied()) {
            permission = StreetTraversalPermission.NONE;
            if (entity.isMotorcarExplicitlyAllowed() || entity.isMotorVehicleExplicitlyAllowed()) {
                permission = permission.add(StreetTraversalPermission.CAR);
            }
            if (entity.isBicycleExplicitlyAllowed()) {
                permission = permission.add(StreetTraversalPermission.BICYCLE);
            }
            if (entity.isPedestrianExplicitlyAllowed()) {
                permission = permission.add(StreetTraversalPermission.PEDESTRIAN);
            }
        } else {
            permission = def;
        }
        if (entity.isMotorcarExplicitlyDenied() || entity.isMotorVehicleExplicitlyDenied()) {
            permission = permission.remove(StreetTraversalPermission.CAR);
        } else if (entity.isMotorcarExplicitlyAllowed() || entity.isMotorVehicleExplicitlyAllowed()) {
            permission = permission.add(StreetTraversalPermission.CAR);
        }
        if (entity.isBicycleExplicitlyDenied()) {
            permission = permission.remove(StreetTraversalPermission.BICYCLE);
        } else if (entity.isBicycleExplicitlyAllowed()) {
            permission = permission.add(StreetTraversalPermission.BICYCLE);
        }
        if (entity.isPedestrianExplicitlyDenied()) {
            permission = permission.remove(StreetTraversalPermission.PEDESTRIAN);
        } else if (entity.isPedestrianExplicitlyAllowed()) {
            permission = permission.add(StreetTraversalPermission.PEDESTRIAN);
        }
        if (entity.isUnderConstruction()) {
            permission = StreetTraversalPermission.NONE;
        }
        if (permission == null) {
            return def;
        }
        return permission;
    }

    public static StreetTraversalPermission getPermissionsForWay(OSMWay way, StreetTraversalPermission def, Graph graph, boolean banDiscouragedWalking, boolean banDiscouragedBiking, DataImportIssueStore issueStore) {
        StreetTraversalPermission permissions = OSMFilter.getPermissionsForEntity(way, def);
        if (way.isPedestrianExplicitlyAllowed()) {
            permissions = permissions.add(StreetTraversalPermission.PEDESTRIAN);
        } else if (way.isPedestrianExplicitlyDenied()) {
            permissions = permissions.remove(StreetTraversalPermission.PEDESTRIAN);
        }
        if (banDiscouragedWalking && way.hasTag("foot") && way.getTag("foot").equals("discouraged")) {
            permissions = permissions.remove(StreetTraversalPermission.PEDESTRIAN);
        }
        boolean forceBikes = false;
        if (way.isBicycleExplicitlyAllowed()) {
            permissions = permissions.add(StreetTraversalPermission.BICYCLE);
            forceBikes = true;
        }
        if (way.isBicycleDismountForced() || banDiscouragedBiking && way.hasTag("bicycle") && way.getTag("bicycle").equals("discouraged")) {
            permissions = permissions.remove(StreetTraversalPermission.BICYCLE);
            if (forceBikes) {
                issueStore.add(new ConflictingBikeTags(way.getId()));
            }
        }
        return permissions;
    }

    public static StreetTraversalPermission getPermissionsForWay(OSMWay way, StreetTraversalPermission def, Graph graph) {
        return OSMFilter.getPermissionsForWay(way, def, graph, false, false, new DataImportIssueStore(false));
    }

    public static P2<StreetTraversalPermission> getPermissions(StreetTraversalPermission permissions, OSMWay way) {
        String oneWayBicycle;
        StreetTraversalPermission permissionsFront = permissions;
        StreetTraversalPermission permissionsBack = permissions;
        if (way.isOneWayForwardDriving() || way.isRoundabout()) {
            permissionsBack = permissionsBack.remove(StreetTraversalPermission.BICYCLE_AND_CAR);
        }
        if (way.isOneWayReverseDriving()) {
            permissionsFront = permissionsFront.remove(StreetTraversalPermission.BICYCLE_AND_CAR);
        }
        if (way.isOneWayForwardBicycle()) {
            permissionsBack = permissionsBack.remove(StreetTraversalPermission.BICYCLE);
        }
        if (way.isOneWayReverseBicycle()) {
            permissionsFront = permissionsFront.remove(StreetTraversalPermission.BICYCLE);
        }
        if ((OSMWithTags.isFalse(oneWayBicycle = way.getTag("oneway:bicycle")) || way.isTagTrue("bicycle:backwards")) && permissions.allows(StreetTraversalPermission.BICYCLE)) {
            permissionsFront = permissionsFront.add(StreetTraversalPermission.BICYCLE);
            permissionsBack = permissionsBack.add(StreetTraversalPermission.BICYCLE);
        }
        if (way.isForwardDirectionSidepath()) {
            permissionsFront = permissionsFront.remove(StreetTraversalPermission.BICYCLE);
        }
        if (way.isReverseDirectionSidepath()) {
            permissionsBack = permissionsBack.remove(StreetTraversalPermission.BICYCLE);
        }
        if (way.isOpposableCycleway()) {
            permissionsBack = permissionsBack.add(StreetTraversalPermission.BICYCLE);
        }
        return new P2<StreetTraversalPermission>(permissionsFront, permissionsBack);
    }

    public static int getStreetClasses(OSMWithTags way) {
        int link = 0;
        String highway = way.getTag("highway");
        if (highway != null && highway.endsWith("_link")) {
            link = 32;
        }
        return OSMFilter.getPlatformClass(way) | link;
    }

    public static int getPlatformClass(OSMWithTags way) {
        String highway = way.getTag("highway");
        if ("platform".equals(way.getTag("railway"))) {
            return 16;
        }
        if ("platform".equals(highway) || "platform".equals(way.getTag("public_transport"))) {
            if (way.isTagTrue("train") || way.isTagTrue("subway") || way.isTagTrue("tram") || way.isTagTrue("monorail")) {
                return 16;
            }
            return 8;
        }
        return 0;
    }
}

