/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import org.opentripplanner.graph_builder.module.osm.DefaultWayPropertySetSource;
import org.opentripplanner.graph_builder.module.osm.WayPropertySet;
import org.opentripplanner.graph_builder.module.osm.WayPropertySetSource;
import org.opentripplanner.routing.core.intersection_model.IntersectionTraversalCostModel;
import org.opentripplanner.routing.core.intersection_model.NorwayIntersectionTraversalCostModel;
import org.opentripplanner.routing.edgetype.StreetTraversalPermission;

public class NorwayWayPropertySetSource
implements WayPropertySetSource {
    private final WayPropertySetSource.DrivingDirection drivingDirection = WayPropertySetSource.DrivingDirection.RIGHT_HAND_TRAFFIC;

    @Override
    public void populateProperties(WayPropertySet props) {
        props.setProperties("highway=trunk_link", StreetTraversalPermission.ALL, 2.06, 2.06);
        props.setProperties("highway=trunk", StreetTraversalPermission.ALL, 7.47, 7.47);
        props.setProperties("highway=trunk;tunnel=yes", StreetTraversalPermission.CAR, 7.47, 7.47);
        props.setProperties("highway=trunk_link;tunnel=yes", StreetTraversalPermission.CAR, 7.47, 7.47);
        props.setProperties("highway=razed", StreetTraversalPermission.NONE);
        props.setProperties("highway=proposed", StreetTraversalPermission.NONE);
        props.setProperties("highway=construction", StreetTraversalPermission.NONE);
        props.setProperties("highway=abandoned", StreetTraversalPermission.NONE);
        props.setProperties("highway=winter_road", StreetTraversalPermission.NONE);
        props.setProperties("highway=historic", StreetTraversalPermission.NONE);
        props.setProperties("highway=proposal_alternative", StreetTraversalPermission.NONE);
        props.setProperties("motorroad=yes", StreetTraversalPermission.CAR, 7.47, 7.47);
        props.setProperties("highway=cycleway;bicycle=designated", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE, 0.97, 0.97);
        props.setProperties("smoothness=horrible", StreetTraversalPermission.NONE);
        props.setProperties("smoothness=impassable", StreetTraversalPermission.NONE);
        props.setProperties("smoothness=very_horrible", StreetTraversalPermission.NONE);
        props.setProperties("smoothness=very_bad", StreetTraversalPermission.NONE);
        props.setProperties("smoothness=bad", StreetTraversalPermission.NONE);
        props.setProperties("smoothness=rough", StreetTraversalPermission.NONE);
        props.setProperties("trail_visibility=bad", StreetTraversalPermission.NONE);
        props.setProperties("trail_visibility=no", StreetTraversalPermission.NONE);
        props.setProperties("trail_visibility=low", StreetTraversalPermission.NONE);
        props.setProperties("trail_visibility=poor", StreetTraversalPermission.NONE);
        props.setProperties("sac_scale=mountain_hiking", StreetTraversalPermission.NONE);
        props.setProperties("sac_scale=demanding_mountain_hiking", StreetTraversalPermission.NONE);
        props.setProperties("sac_scale=alpine_hiking", StreetTraversalPermission.NONE);
        props.setProperties("sac_scale=demanding_alpine_hiking", StreetTraversalPermission.NONE);
        props.setProperties("sac_scale=difficult_alpine_hiking", StreetTraversalPermission.NONE);
        props.setProperties("footway=sidewalk;highway=footway", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE);
        props.setCarSpeed("highway=motorway", 22.22f);
        props.setCarSpeed("highway=motorway_link", 22.22f);
        props.setCarSpeed("highway=trunk", 22.22f);
        props.setCarSpeed("highway=trunk_link", 22.22f);
        props.setCarSpeed("highway=primary", 22.22f);
        props.setCarSpeed("highway=primary_link", 22.22f);
        props.setCarSpeed("highway=secondary", 22.22f);
        props.setCarSpeed("highway=secondary_link", 22.22f);
        props.setCarSpeed("highway=tertiary", 22.22f);
        props.setCarSpeed("highway=tertiary_link", 22.22f);
        props.setCarSpeed("highway=living_street", 1.94f);
        props.setCarSpeed("highway=pedestrian", 1.94f);
        props.setCarSpeed("highway=residential", 8.33f);
        props.setCarSpeed("highway=unclassified", 22.22f);
        props.setCarSpeed("highway=service", 13.89f);
        props.setCarSpeed("highway=track", 8.33f);
        props.setCarSpeed("highway=road", 13.89f);
        props.defaultSpeed = Float.valueOf(22.22f);
        new DefaultWayPropertySetSource().populateProperties(props);
    }

    @Override
    public WayPropertySetSource.DrivingDirection drivingDirection() {
        return this.drivingDirection;
    }

    @Override
    public IntersectionTraversalCostModel getIntersectionTraversalCostModel() {
        return new NorwayIntersectionTraversalCostModel(this.drivingDirection);
    }
}

