/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import org.opentripplanner.graph_builder.module.osm.DefaultWayPropertySetSource;
import org.opentripplanner.graph_builder.module.osm.WayPropertySet;
import org.opentripplanner.graph_builder.module.osm.WayPropertySetSource;
import org.opentripplanner.routing.core.intersection_model.IntersectionTraversalCostModel;
import org.opentripplanner.routing.core.intersection_model.SimpleIntersectionTraversalCostModel;
import org.opentripplanner.routing.edgetype.StreetTraversalPermission;

public class GermanyWayPropertySetSource
implements WayPropertySetSource {
    private final WayPropertySetSource.DrivingDirection drivingDirection = WayPropertySetSource.DrivingDirection.RIGHT_HAND_TRAFFIC;

    @Override
    public void populateProperties(WayPropertySet props) {
        props.setCarSpeed("highway=motorway", 33.33f);
        props.setCarSpeed("highway=motorway_link", 15.0f);
        props.setCarSpeed("highway=trunk", 27.27f);
        props.setCarSpeed("highway=trunk_link", 15.0f);
        props.setCarSpeed("highway=primary", 27.27f);
        props.setCarSpeed("highway=primary_link", 15.0f);
        props.setCarSpeed("service=parking_aisle", 5.0f);
        props.setProperties("highway=track", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE, 1.0, 1.0);
        props.setProperties("highway=track;surface=*", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE, 1.0, 1.0);
        props.setProperties("highway=residential;junction=roundabout", StreetTraversalPermission.ALL, 0.98, 0.98);
        props.setProperties("highway=*;junction=roundabout", StreetTraversalPermission.BICYCLE_AND_CAR);
        props.setProperties("highway=pedestrian", StreetTraversalPermission.PEDESTRIAN);
        props.setProperties("highway=residential;maxspeed=30", StreetTraversalPermission.ALL, 0.9, 0.9);
        props.setProperties("highway=footway;bicycle=yes", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE, 0.8, 0.8);
        props.setProperties("footway=sidewalk;highway=footway;bicycle=yes", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE, 1.2, 1.2);
        props.setProperties("highway=tertiary", StreetTraversalPermission.ALL, 1.2, 1.2, true);
        props.setProperties("maxspeed=70", StreetTraversalPermission.ALL, 1.5, 1.5, true);
        props.setProperties("maxspeed=80", StreetTraversalPermission.ALL, 2.0, 2.0, true);
        props.setProperties("maxspeed=90", StreetTraversalPermission.ALL, 3.0, 3.0, true);
        props.setProperties("maxspeed=100", StreetTraversalPermission.ALL, 5.0, 5.0, true);
        props.setProperties("tracktype=grade1", StreetTraversalPermission.ALL, 1.0, 1.0, true);
        props.setProperties("tracktype=grade2", StreetTraversalPermission.ALL, 1.1, 1.1, true);
        props.setProperties("tracktype=grade3", StreetTraversalPermission.ALL, 1.15, 1.15, true);
        props.setProperties("tracktype=grade4", StreetTraversalPermission.ALL, 1.3, 1.3, true);
        props.setProperties("tracktype=grade5", StreetTraversalPermission.ALL, 1.5, 1.5, true);
        props.setProperties("lit=no", StreetTraversalPermission.ALL, 1.05, 1.05, true);
        props.setProperties("highway=unclassified;cycleway=lane", StreetTraversalPermission.ALL, 0.87, 0.87);
        new DefaultWayPropertySetSource().populateProperties(props);
    }

    @Override
    public WayPropertySetSource.DrivingDirection drivingDirection() {
        return this.drivingDirection;
    }

    @Override
    public IntersectionTraversalCostModel getIntersectionTraversalCostModel() {
        return new SimpleIntersectionTraversalCostModel(this.drivingDirection);
    }
}

