/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import org.opentripplanner.graph_builder.module.osm.DefaultWayPropertySetSource;
import org.opentripplanner.graph_builder.module.osm.WayPropertySet;
import org.opentripplanner.graph_builder.module.osm.WayPropertySetSource;
import org.opentripplanner.routing.core.intersection_model.IntersectionTraversalCostModel;
import org.opentripplanner.routing.core.intersection_model.SimpleIntersectionTraversalCostModel;
import org.opentripplanner.routing.edgetype.StreetTraversalPermission;

public class FinlandWayPropertySetSource
implements WayPropertySetSource {
    private final WayPropertySetSource.DrivingDirection drivingDirection = WayPropertySetSource.DrivingDirection.RIGHT_HAND_TRAFFIC;

    @Override
    public void populateProperties(WayPropertySet props) {
        props.setProperties("highway=trunk_link", StreetTraversalPermission.ALL, 2.06, 2.06);
        props.setProperties("highway=trunk", StreetTraversalPermission.ALL, 7.47, 7.47);
        props.setProperties("highway=trunk;tunnel=yes", StreetTraversalPermission.CAR, 7.47, 7.47);
        props.setProperties("motorroad=yes", StreetTraversalPermission.CAR, 7.47, 7.47);
        props.setProperties("highway=*;informal=yes", StreetTraversalPermission.NONE);
        props.setProperties("highway=service;access=private", StreetTraversalPermission.NONE);
        props.setProperties("highway=trail", StreetTraversalPermission.NONE);
        props.setProperties("highway=footway", StreetTraversalPermission.PEDESTRIAN);
        props.setProperties("highway=cycleway;bicycle=designated", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE, 0.6, 0.6);
        props.setProperties("highway=service;tunnel=yes;access=destination", StreetTraversalPermission.NONE);
        props.setProperties("highway=service;access=destination", StreetTraversalPermission.ALL, 1.1, 1.1);
        props.setCarSpeed("highway=motorway", 27.77f);
        props.setCarSpeed("highway=motorway_link", 15.0f);
        props.setCarSpeed("highway=trunk", 22.22f);
        props.setCarSpeed("highway=trunk_link", 15.0f);
        props.setCarSpeed("highway=primary", 22.22f);
        props.setCarSpeed("highway=primary_link", 15.0f);
        new DefaultWayPropertySetSource().populateProperties(props);
    }

    @Override
    public WayPropertySetSource.DrivingDirection drivingDirection() {
        return this.drivingDirection;
    }

    @Override
    public IntersectionTraversalCostModel getIntersectionTraversalCostModel() {
        return new SimpleIntersectionTraversalCostModel(this.drivingDirection);
    }
}

