/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import org.opentripplanner.graph_builder.module.osm.OSMSpecifier;
import org.opentripplanner.graph_builder.module.osm.WayPropertySet;
import org.opentripplanner.graph_builder.module.osm.WayPropertySetSource;
import org.opentripplanner.routing.core.intersection_model.IntersectionTraversalCostModel;
import org.opentripplanner.routing.core.intersection_model.SimpleIntersectionTraversalCostModel;
import org.opentripplanner.routing.edgetype.StreetTraversalPermission;
import org.opentripplanner.routing.services.notes.StreetNotesService;

public class DefaultWayPropertySetSource
implements WayPropertySetSource {
    private final WayPropertySetSource.DrivingDirection drivingDirection = WayPropertySetSource.DrivingDirection.RIGHT_HAND_TRAFFIC;

    @Override
    public void populateProperties(WayPropertySet props) {
        props.setProperties("highway=raceway", StreetTraversalPermission.NONE);
        props.setProperties("highway=construction", StreetTraversalPermission.NONE);
        props.setProperties("mtb:scale=3", StreetTraversalPermission.NONE);
        props.setProperties("mtb:scale=4", StreetTraversalPermission.NONE);
        props.setProperties("mtb:scale=5", StreetTraversalPermission.NONE);
        props.setProperties("mtb:scale=6", StreetTraversalPermission.NONE);
        props.setProperties("highway=corridor", StreetTraversalPermission.PEDESTRIAN);
        props.setProperties("highway=steps", StreetTraversalPermission.PEDESTRIAN);
        props.setProperties("highway=crossing", StreetTraversalPermission.PEDESTRIAN);
        props.setProperties("highway=platform", StreetTraversalPermission.PEDESTRIAN);
        props.setProperties("public_transport=platform", StreetTraversalPermission.PEDESTRIAN);
        props.setProperties("railway=platform", StreetTraversalPermission.PEDESTRIAN);
        props.setProperties("footway=sidewalk;highway=footway", StreetTraversalPermission.PEDESTRIAN);
        props.setProperties("mtb:scale=1", StreetTraversalPermission.PEDESTRIAN);
        props.setProperties("mtb:scale=2", StreetTraversalPermission.PEDESTRIAN);
        props.setProperties("mtb:scale=0", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE);
        props.setProperties("highway=cycleway", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE, 0.6, 0.6);
        props.setProperties("highway=path", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE, 0.75, 0.75);
        props.setProperties("highway=pedestrian", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE, 0.9, 0.9);
        props.setProperties("highway=footway", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE, 1.1, 1.1);
        props.setProperties("highway=bridleway", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE, 1.3, 1.3);
        props.setProperties("highway=living_street", StreetTraversalPermission.ALL, 0.9, 0.9);
        props.setProperties("highway=unclassified", StreetTraversalPermission.ALL, 1.0, 1.0);
        props.setProperties("highway=road", StreetTraversalPermission.ALL, 1.0, 1.0);
        props.setProperties("highway=byway", StreetTraversalPermission.ALL, 1.3, 1.3);
        props.setProperties("highway=track", StreetTraversalPermission.ALL, 1.3, 1.3);
        props.setProperties("highway=service", StreetTraversalPermission.ALL, 1.1, 1.1);
        props.setProperties("highway=residential", StreetTraversalPermission.ALL, 0.98, 0.98);
        props.setProperties("highway=residential_link", StreetTraversalPermission.ALL, 0.98, 0.98);
        props.setProperties("highway=tertiary", StreetTraversalPermission.ALL, 1.0, 1.0);
        props.setProperties("highway=tertiary_link", StreetTraversalPermission.ALL, 1.0, 1.0);
        props.setProperties("highway=secondary", StreetTraversalPermission.ALL, 1.5, 1.5);
        props.setProperties("highway=secondary_link", StreetTraversalPermission.ALL, 1.5, 1.5);
        props.setProperties("highway=primary", StreetTraversalPermission.ALL, 2.06, 2.06);
        props.setProperties("highway=primary_link", StreetTraversalPermission.ALL, 2.06, 2.06);
        props.setProperties("highway=trunk_link", StreetTraversalPermission.CAR, 2.06, 2.06);
        props.setProperties("highway=motorway_link", StreetTraversalPermission.CAR, 2.06, 2.06);
        props.setProperties("highway=trunk", StreetTraversalPermission.CAR, 7.47, 7.47);
        props.setProperties("highway=motorway", StreetTraversalPermission.CAR, 8.0, 8.0);
        props.setProperties("highway=*;cycleway=lane", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE, 0.87, 0.87);
        props.setProperties("highway=service;cycleway=lane", StreetTraversalPermission.ALL, 0.77, 0.77);
        props.setProperties("highway=residential;cycleway=lane", StreetTraversalPermission.ALL, 0.77, 0.77);
        props.setProperties("highway=residential_link;cycleway=lane", StreetTraversalPermission.ALL, 0.77, 0.77);
        props.setProperties("highway=tertiary;cycleway=lane", StreetTraversalPermission.ALL, 0.87, 0.87);
        props.setProperties("highway=tertiary_link;cycleway=lane", StreetTraversalPermission.ALL, 0.87, 0.87);
        props.setProperties("highway=secondary;cycleway=lane", StreetTraversalPermission.ALL, 0.96, 0.96);
        props.setProperties("highway=secondary_link;cycleway=lane", StreetTraversalPermission.ALL, 0.96, 0.96);
        props.setProperties("highway=primary;cycleway=lane", StreetTraversalPermission.ALL, 1.15, 1.15);
        props.setProperties("highway=primary_link;cycleway=lane", StreetTraversalPermission.ALL, 1.15, 1.15);
        props.setProperties("highway=trunk;cycleway=lane", StreetTraversalPermission.BICYCLE_AND_CAR, 1.5, 1.5);
        props.setProperties("highway=trunk_link;cycleway=lane", StreetTraversalPermission.BICYCLE_AND_CAR, 1.15, 1.15);
        props.setProperties("highway=motorway;cycleway=lane", StreetTraversalPermission.BICYCLE_AND_CAR, 2.0, 2.0);
        props.setProperties("highway=motorway_link;cycleway=lane", StreetTraversalPermission.BICYCLE_AND_CAR, 1.15, 1.15);
        props.setProperties("highway=*;cycleway=share_busway", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE, 0.92, 0.92);
        props.setProperties("highway=service;cycleway=share_busway", StreetTraversalPermission.ALL, 0.85, 0.85);
        props.setProperties("highway=residential;cycleway=share_busway", StreetTraversalPermission.ALL, 0.85, 0.85);
        props.setProperties("highway=residential_link;cycleway=share_busway", StreetTraversalPermission.ALL, 0.85, 0.85);
        props.setProperties("highway=tertiary;cycleway=share_busway", StreetTraversalPermission.ALL, 0.92, 0.92);
        props.setProperties("highway=tertiary_link;cycleway=share_busway", StreetTraversalPermission.ALL, 0.92, 0.92);
        props.setProperties("highway=secondary;cycleway=share_busway", StreetTraversalPermission.ALL, 0.99, 0.99);
        props.setProperties("highway=secondary_link;cycleway=share_busway", StreetTraversalPermission.ALL, 0.99, 0.99);
        props.setProperties("highway=primary;cycleway=share_busway", StreetTraversalPermission.ALL, 1.25, 1.25);
        props.setProperties("highway=primary_link;cycleway=share_busway", StreetTraversalPermission.ALL, 1.25, 1.25);
        props.setProperties("highway=trunk;cycleway=share_busway", StreetTraversalPermission.BICYCLE_AND_CAR, 1.75, 1.75);
        props.setProperties("highway=trunk_link;cycleway=share_busway", StreetTraversalPermission.BICYCLE_AND_CAR, 1.25, 1.25);
        props.setProperties("highway=motorway;cycleway=share_busway", StreetTraversalPermission.BICYCLE_AND_CAR, 2.5, 2.5);
        props.setProperties("highway=motorway_link;cycleway=share_busway", StreetTraversalPermission.BICYCLE_AND_CAR, 1.25, 1.25);
        props.setProperties("highway=*;cycleway=opposite_lane", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE, 1.0, 0.87);
        props.setProperties("highway=service;cycleway=opposite_lane", StreetTraversalPermission.ALL, 1.1, 0.77);
        props.setProperties("highway=residential;cycleway=opposite_lane", StreetTraversalPermission.ALL, 0.98, 0.77);
        props.setProperties("highway=residential_link;cycleway=opposite_lane", StreetTraversalPermission.ALL, 0.98, 0.77);
        props.setProperties("highway=tertiary;cycleway=opposite_lane", StreetTraversalPermission.ALL, 1.0, 0.87);
        props.setProperties("highway=tertiary_link;cycleway=opposite_lane", StreetTraversalPermission.ALL, 1.0, 0.87);
        props.setProperties("highway=secondary;cycleway=opposite_lane", StreetTraversalPermission.ALL, 1.5, 0.96);
        props.setProperties("highway=secondary_link;cycleway=opposite_lane", StreetTraversalPermission.ALL, 1.5, 0.96);
        props.setProperties("highway=primary;cycleway=opposite_lane", StreetTraversalPermission.ALL, 2.06, 1.15);
        props.setProperties("highway=primary_link;cycleway=opposite_lane", StreetTraversalPermission.ALL, 2.06, 1.15);
        props.setProperties("highway=trunk;cycleway=opposite_lane", StreetTraversalPermission.BICYCLE_AND_CAR, 7.47, 1.5);
        props.setProperties("highway=trunk_link;cycleway=opposite_lane", StreetTraversalPermission.BICYCLE_AND_CAR, 2.06, 1.15);
        props.setProperties("highway=*;cycleway=track", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE, 0.75, 0.75);
        props.setProperties("highway=service;cycleway=track", StreetTraversalPermission.ALL, 0.65, 0.65);
        props.setProperties("highway=residential;cycleway=track", StreetTraversalPermission.ALL, 0.65, 0.65);
        props.setProperties("highway=residential_link;cycleway=track", StreetTraversalPermission.ALL, 0.65, 0.65);
        props.setProperties("highway=tertiary;cycleway=track", StreetTraversalPermission.ALL, 0.75, 0.75);
        props.setProperties("highway=tertiary_link;cycleway=track", StreetTraversalPermission.ALL, 0.75, 0.75);
        props.setProperties("highway=secondary;cycleway=track", StreetTraversalPermission.ALL, 0.8, 0.8);
        props.setProperties("highway=secondary_link;cycleway=track", StreetTraversalPermission.ALL, 0.8, 0.8);
        props.setProperties("highway=primary;cycleway=track", StreetTraversalPermission.ALL, 0.85, 0.85);
        props.setProperties("highway=primary_link;cycleway=track", StreetTraversalPermission.ALL, 0.85, 0.85);
        props.setProperties("highway=trunk;cycleway=track", StreetTraversalPermission.BICYCLE_AND_CAR, 0.95, 0.95);
        props.setProperties("highway=trunk_link;cycleway=track", StreetTraversalPermission.BICYCLE_AND_CAR, 0.85, 0.85);
        props.setProperties("highway=*;cycleway=opposite_track", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE, 1.0, 0.75);
        props.setProperties("highway=service;cycleway=opposite_track", StreetTraversalPermission.ALL, 1.1, 0.65);
        props.setProperties("highway=residential;cycleway=opposite_track", StreetTraversalPermission.ALL, 0.98, 0.65);
        props.setProperties("highway=residential_link;cycleway=opposite_track", StreetTraversalPermission.ALL, 0.98, 0.65);
        props.setProperties("highway=tertiary;cycleway=opposite_track", StreetTraversalPermission.ALL, 1.0, 0.75);
        props.setProperties("highway=tertiary_link;cycleway=opposite_track", StreetTraversalPermission.ALL, 1.0, 0.75);
        props.setProperties("highway=secondary;cycleway=opposite_track", StreetTraversalPermission.ALL, 1.5, 0.8);
        props.setProperties("highway=secondary_link;cycleway=opposite_track", StreetTraversalPermission.ALL, 1.5, 0.8);
        props.setProperties("highway=primary;cycleway=opposite_track", StreetTraversalPermission.ALL, 2.06, 0.85);
        props.setProperties("highway=primary_link;cycleway=opposite_track", StreetTraversalPermission.ALL, 2.06, 0.85);
        props.setProperties("highway=trunk;cycleway=opposite_track", StreetTraversalPermission.BICYCLE_AND_CAR, 7.47, 0.95);
        props.setProperties("highway=trunk_link;cycleway=opposite_track", StreetTraversalPermission.BICYCLE_AND_CAR, 2.06, 0.85);
        props.setProperties("highway=*;cycleway=shared_lane", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE, 0.77, 0.77);
        props.setProperties("highway=service;cycleway=shared_lane", StreetTraversalPermission.ALL, 0.73, 0.73);
        props.setProperties("highway=residential;cycleway=shared_lane", StreetTraversalPermission.ALL, 0.77, 0.77);
        props.setProperties("highway=residential_link;cycleway=shared_lane", StreetTraversalPermission.ALL, 0.77, 0.77);
        props.setProperties("highway=tertiary;cycleway=shared_lane", StreetTraversalPermission.ALL, 0.83, 0.83);
        props.setProperties("highway=tertiary_link;cycleway=shared_lane", StreetTraversalPermission.ALL, 0.83, 0.83);
        props.setProperties("highway=secondary;cycleway=shared_lane", StreetTraversalPermission.ALL, 1.25, 1.25);
        props.setProperties("highway=secondary_link;cycleway=shared_lane", StreetTraversalPermission.ALL, 1.25, 1.25);
        props.setProperties("highway=primary;cycleway=shared_lane", StreetTraversalPermission.ALL, 1.75, 1.75);
        props.setProperties("highway=primary_link;cycleway=shared_lane", StreetTraversalPermission.ALL, 1.75, 1.75);
        props.setProperties("highway=*;cycleway=opposite", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE, 1.0, 1.4);
        props.setProperties("highway=service;cycleway=opposite", StreetTraversalPermission.ALL, 1.1, 1.1);
        props.setProperties("highway=residential;cycleway=opposite", StreetTraversalPermission.ALL, 0.98, 0.98);
        props.setProperties("highway=residential_link;cycleway=opposite", StreetTraversalPermission.ALL, 0.98, 0.98);
        props.setProperties("highway=tertiary;cycleway=opposite", StreetTraversalPermission.ALL, 1.0, 1.0);
        props.setProperties("highway=tertiary_link;cycleway=opposite", StreetTraversalPermission.ALL, 1.0, 1.0);
        props.setProperties("highway=secondary;cycleway=opposite", StreetTraversalPermission.ALL, 1.5, 1.71);
        props.setProperties("highway=secondary_link;cycleway=opposite", StreetTraversalPermission.ALL, 1.5, 1.71);
        props.setProperties("highway=primary;cycleway=opposite", StreetTraversalPermission.ALL, 2.06, 2.99);
        props.setProperties("highway=primary_link;cycleway=opposite", StreetTraversalPermission.ALL, 2.06, 2.99);
        props.setProperties("highway=path;bicycle=designated", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE, 0.6, 0.6);
        props.setProperties("highway=footway;bicycle=designated", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE, 0.75, 0.75);
        props.setProperties("highway=footway;bicycle=yes;area=yes", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE, 0.9, 0.9);
        props.setProperties("highway=pedestrian;bicycle=designated", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE, 0.75, 0.75);
        props.setProperties("footway=sidewalk;highway=footway;bicycle=yes", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE, 2.5, 2.5);
        props.setProperties("footway=sidewalk;highway=footway;bicycle=designated", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE, 1.1, 1.1);
        props.setProperties("highway=footway;footway=crossing", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE, 2.5, 2.5);
        props.setProperties("highway=footway;footway=crossing;bicycle=designated", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE, 1.1, 1.1);
        props.setProperties("highway=track;bicycle=yes", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE, 1.18, 1.18);
        props.setProperties("highway=track;bicycle=designated", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE, 0.99, 0.99);
        props.setProperties("highway=track;bicycle=yes;surface=*", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE, 1.18, 1.18);
        props.setProperties("highway=track;bicycle=designated;surface=*", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE, 0.99, 0.99);
        props.setProperties("highway=track;surface=*", StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE, 1.3, 1.3);
        props.setProperties("highway=*;bicycle=designated", StreetTraversalPermission.ALL, 0.97, 0.97);
        props.setProperties("highway=service;bicycle=designated", StreetTraversalPermission.ALL, 0.84, 0.84);
        props.setProperties("highway=residential;bicycle=designated", StreetTraversalPermission.ALL, 0.95, 0.95);
        props.setProperties("highway=unclassified;bicycle=designated", StreetTraversalPermission.ALL, 0.95, 0.95);
        props.setProperties("highway=residential_link;bicycle=designated", StreetTraversalPermission.ALL, 0.95, 0.95);
        props.setProperties("highway=tertiary;bicycle=designated", StreetTraversalPermission.ALL, 0.97, 0.97);
        props.setProperties("highway=tertiary_link;bicycle=designated", StreetTraversalPermission.ALL, 0.97, 0.97);
        props.setProperties("highway=secondary;bicycle=designated", StreetTraversalPermission.ALL, 1.46, 1.46);
        props.setProperties("highway=secondary_link;bicycle=designated", StreetTraversalPermission.ALL, 1.46, 1.46);
        props.setProperties("highway=primary;bicycle=designated", StreetTraversalPermission.ALL, 2.0, 2.0);
        props.setProperties("highway=primary_link;bicycle=designated", StreetTraversalPermission.ALL, 2.0, 2.0);
        props.setProperties("highway=trunk;bicycle=designated", StreetTraversalPermission.BICYCLE_AND_CAR, 7.25, 7.25);
        props.setProperties("highway=trunk_link;bicycle=designated", StreetTraversalPermission.BICYCLE_AND_CAR, 2.0, 2.0);
        props.setProperties("highway=motorway;bicycle=designated", StreetTraversalPermission.BICYCLE_AND_CAR, 7.76, 7.76);
        props.setProperties("highway=motorway_link;bicycle=designated", StreetTraversalPermission.BICYCLE_AND_CAR, 2.0, 2.0);
        props.setProperties("lcn=yes|rcn=yes|ncn=yes", StreetTraversalPermission.ALL, 0.7, 0.7, true);
        props.setCarSpeed("highway=motorway", 29.0f);
        props.setCarSpeed("highway=motorway_link", 15.0f);
        props.setCarSpeed("highway=trunk", 24.6f);
        props.setCarSpeed("highway=trunk_link", 15.0f);
        props.setCarSpeed("highway=primary", 20.0f);
        props.setCarSpeed("highway=primary_link", 11.2f);
        props.setCarSpeed("highway=secondary", 15.0f);
        props.setCarSpeed("highway=secondary_link", 11.2f);
        props.setCarSpeed("highway=tertiary", 11.2f);
        props.setCarSpeed("highway=tertiary_link", 11.2f);
        props.setCarSpeed("highway=living_street", 2.2f);
        props.setCarSpeed("highway=pedestrian", 2.2f);
        props.setCarSpeed("highway=residential", 11.2f);
        props.setCarSpeed("highway=unclassified", 11.2f);
        props.setCarSpeed("highway=service", 6.7f);
        props.setCarSpeed("highway=track", 4.5f);
        props.setCarSpeed("highway=road", 11.2f);
        props.defaultSpeed = Float.valueOf(11.2f);
        props.setProperties("surface=unpaved", StreetTraversalPermission.ALL, 1.18, 1.18, true);
        props.setProperties("surface=compacted", StreetTraversalPermission.ALL, 1.18, 1.18, true);
        props.setProperties("surface=wood", StreetTraversalPermission.ALL, 1.18, 1.18, true);
        props.setProperties("surface=cobblestone", StreetTraversalPermission.ALL, 1.3, 1.3, true);
        props.setProperties("surface=cobblestone:flattened", StreetTraversalPermission.ALL, 1.3, 1.3, true);
        props.setProperties("surface=grass_paver", StreetTraversalPermission.ALL, 1.3, 1.3, true);
        props.setProperties("surface=pebblestone", StreetTraversalPermission.ALL, 1.3, 1.3, true);
        props.setProperties("surface=metal", StreetTraversalPermission.ALL, 1.3, 1.3, true);
        props.setProperties("surface=ground", StreetTraversalPermission.ALL, 1.5, 1.5, true);
        props.setProperties("surface=dirt", StreetTraversalPermission.ALL, 1.5, 1.5, true);
        props.setProperties("surface=earth", StreetTraversalPermission.ALL, 1.5, 1.5, true);
        props.setProperties("surface=grass", StreetTraversalPermission.ALL, 1.5, 1.5, true);
        props.setProperties("surface=mud", StreetTraversalPermission.ALL, 1.5, 1.5, true);
        props.setProperties("surface=woodchip", StreetTraversalPermission.ALL, 1.5, 1.5, true);
        props.setProperties("surface=gravel", StreetTraversalPermission.ALL, 1.5, 1.5, true);
        props.setProperties("surface=artifical_turf", StreetTraversalPermission.ALL, 1.5, 1.5, true);
        props.setProperties("surface=sand", StreetTraversalPermission.ALL, 100.0, 100.0, true);
        props.setProperties("RLIS:bicycle=caution_area", StreetTraversalPermission.ALL, 1.45, 1.45, true);
        props.setProperties("RLIS:bicycle:right=caution_area", StreetTraversalPermission.ALL, 1.45, 1.0, true);
        props.setProperties("RLIS:bicycle:left=caution_area", StreetTraversalPermission.ALL, 1.0, 1.45, true);
        props.setProperties("CCGIS:bicycle=caution_area", StreetTraversalPermission.ALL, 1.45, 1.45, true);
        props.setProperties("CCGIS:bicycle:right=caution_area", StreetTraversalPermission.ALL, 1.45, 1.0, true);
        props.setProperties("CCGIS:bicycle:left=caution_area", StreetTraversalPermission.ALL, 1.0, 1.45, true);
        props.defaultProperties.setPermission(StreetTraversalPermission.ALL);
        props.createNotes("RLIS:bicycle=caution_area", "note.caution", StreetNotesService.BICYCLE_MATCHER);
        props.createNotes("CCGIS:bicycle=caution_area", "note.caution", StreetNotesService.BICYCLE_MATCHER);
        props.createNotes("surface=unpaved", "note.unpaved_surface", StreetNotesService.ALWAYS_MATCHER);
        props.createNotes("surface=compacted", "note.unpaved_surface", StreetNotesService.ALWAYS_MATCHER);
        props.createNotes("surface=ground", "note.unpaved_surface", StreetNotesService.ALWAYS_MATCHER);
        props.createNotes("surface=dirt", "note.unpaved_surface", StreetNotesService.ALWAYS_MATCHER);
        props.createNotes("surface=earth", "note.unpaved_surface", StreetNotesService.ALWAYS_MATCHER);
        props.createNotes("surface=grass", "note.unpaved_surface", StreetNotesService.ALWAYS_MATCHER);
        props.createNotes("surface=mud", "note.muddy_surface", StreetNotesService.ALWAYS_MATCHER);
        props.createNotes("toll=yes", "note.toll", StreetNotesService.DRIVING_MATCHER);
        props.createNotes("toll:motorcar=yes", "note.toll", StreetNotesService.DRIVING_MATCHER);
        props.createNames("highway=cycleway", "name.bike_path");
        props.createNames("cycleway=track", "name.bike_path");
        props.createNames("highway=pedestrian", "name.pedestrian_path");
        props.createNames("highway=pedestrian;area=yes", "name.pedestrian_area");
        props.createNames("highway=path", "name.path");
        props.createNames("highway=footway", "name.pedestrian_path");
        props.createNames("highway=bridleway", "name.bridleway");
        props.createNames("highway=footway;bicycle=no", "name.pedestrian_path");
        props.createNames("otp:route_ref=*", "name.otp_route_ref");
        props.createNames("highway=platform;ref=*", "name.platform_ref");
        props.createNames("railway=platform;ref=*", "name.platform_ref");
        props.createNames("railway=platform;highway=footway;footway=sidewalk", "name.platform");
        props.createNames("railway=platform;highway=path;path=sidewalk", "name.platform");
        props.createNames("railway=platform;highway=pedestrian", "name.platform");
        props.createNames("railway=platform;highway=path", "name.platform");
        props.createNames("railway=platform;highway=footway", "name.platform");
        props.createNames("highway=platform", "name.platform");
        props.createNames("railway=platform", "name.platform");
        props.createNames("railway=platform;highway=footway;bicycle=no", "name.platform");
        props.createNames("highway=pedestrian;bridge=*", "name.footbridge");
        props.createNames("highway=path;bridge=*", "name.footbridge");
        props.createNames("highway=footway;bridge=*", "name.footbridge");
        props.createNames("highway=pedestrian;tunnel=*", "name.underpass");
        props.createNames("highway=path;tunnel=*", "name.underpass");
        props.createNames("highway=footway;tunnel=*", "name.underpass");
        props.createNames("highway=motorway", "name.road");
        props.createNames("highway=motorway_link", "name.ramp");
        props.createNames("highway=trunk", "name.road");
        props.createNames("highway=trunk_link", "name.ramp");
        props.createNames("highway=primary", "name.road");
        props.createNames("highway=primary_link", "name.link");
        props.createNames("highway=secondary", "name.road");
        props.createNames("highway=secondary_link", "name.link");
        props.createNames("highway=tertiary", "name.road");
        props.createNames("highway=tertiary_link", "name.link");
        props.createNames("highway=unclassified", "name.road");
        props.createNames("highway=residential", "name.road");
        props.createNames("highway=living_street", "name.road");
        props.createNames("highway=road", "name.road");
        props.createNames("highway=service", "name.service_road");
        props.createNames("highway=service;service=alley", "name.alley");
        props.createNames("highway=service;service=parking_aisle", "name.parking_aisle");
        props.createNames("highway=byway", "name.byway");
        props.createNames("highway=track", "name.track");
        props.createNames("highway=footway;footway=sidewalk", "name.sidewalk");
        props.createNames("highway=path;path=sidewalk", "name.sidewalk");
        props.createNames("highway=steps", "name.steps");
        props.createNames("amenity=bicycle_parking;name=*", "name.bicycle_parking_name");
        props.createNames("amenity=bicycle_parking", "name.bicycle_parking");
        props.createNames("amenity=parking;name=*", "name.park_and_ride_name");
        props.createNames("amenity=parking", "name.park_and_ride_station");
        props.setSlopeOverride(new OSMSpecifier("bridge=*"), true);
        props.setSlopeOverride(new OSMSpecifier("embankment=*"), true);
        props.setSlopeOverride(new OSMSpecifier("tunnel=*"), true);
    }

    @Override
    public WayPropertySetSource.DrivingDirection drivingDirection() {
        return this.drivingDirection;
    }

    @Override
    public IntersectionTraversalCostModel getIntersectionTraversalCostModel() {
        return new SimpleIntersectionTraversalCostModel(this.drivingDirection);
    }
}

