/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import com.google.common.collect.LinkedListMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.opentripplanner.common.DisjointSet;
import org.opentripplanner.common.geometry.GeometryUtils;
import org.opentripplanner.graph_builder.module.osm.Area;
import org.opentripplanner.graph_builder.module.osm.Ring;
import org.opentripplanner.openstreetmap.model.OSMLevel;
import org.opentripplanner.openstreetmap.model.OSMNode;
import org.opentripplanner.openstreetmap.model.OSMWithTags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AreaGroup {
    private static Logger LOG = LoggerFactory.getLogger(AreaGroup.class);
    Collection<Area> areas;
    List<Ring> outermostRings = new ArrayList<Ring>();

    public AreaGroup(Collection<Area> areas) {
        this.areas = areas;
        ArrayList<Polygon> allRings = new ArrayList<Polygon>();
        HashMap<Coordinate, OSMNode> nodeMap = new HashMap<Coordinate, OSMNode>();
        for (Area area : areas) {
            for (Ring ring : area.outermostRings) {
                allRings.add(ring.jtsPolygon);
                for (OSMNode node : ring.nodes) {
                    nodeMap.put(new Coordinate(node.lon, node.lat), node);
                }
                for (Ring inner : ring.getHoles()) {
                    for (OSMNode node : inner.nodes) {
                        nodeMap.put(new Coordinate(node.lon, node.lat), node);
                    }
                }
            }
        }
        GeometryFactory geometryFactory = GeometryUtils.getGeometryFactory();
        MultiPolygon u = geometryFactory.createMultiPolygon(allRings.toArray(new Polygon[allRings.size()]));
        if ((u = u.union()) instanceof GeometryCollection) {
            GeometryCollection mp = (GeometryCollection)u;
            for (int i = 0; i < mp.getNumGeometries(); ++i) {
                Geometry poly = mp.getGeometryN(i);
                if (!(poly instanceof Polygon)) {
                    LOG.warn("Unexpected non-polygon when merging areas: " + poly);
                    continue;
                }
                this.outermostRings.add(this.toRing((Polygon)poly, nodeMap));
            }
        } else if (u instanceof Polygon) {
            this.outermostRings.add(this.toRing((Polygon)u, nodeMap));
        } else {
            LOG.warn("Unexpected non-polygon when merging areas: " + (Geometry)u);
        }
    }

    public static List<AreaGroup> groupAreas(Map<Area, OSMLevel> areasLevels) {
        DisjointSet<Area> groups = new DisjointSet<Area>();
        LinkedListMultimap areasForNode = LinkedListMultimap.create();
        for (Area area : areasLevels.keySet()) {
            for (Ring ring : area.outermostRings) {
                for (Ring ring2 : ring.getHoles()) {
                    for (OSMNode node : ring2.nodes) {
                        areasForNode.put((Object)node, (Object)area);
                    }
                }
                for (OSMNode oSMNode : ring.nodes) {
                    areasForNode.put((Object)oSMNode, (Object)area);
                }
            }
        }
        for (OSMNode osmNode : areasForNode.keySet()) {
            for (Area area1 : areasForNode.get((Object)osmNode)) {
                OSMLevel level1 = areasLevels.get(area1);
                for (Area area2 : areasForNode.get((Object)osmNode)) {
                    OSMLevel level2 = areasLevels.get(area2);
                    if ((level1 != null || level2 != null) && (level1 == null || !level1.equals(level2))) continue;
                    groups.union(area1, area2);
                }
            }
        }
        ArrayList<AreaGroup> out = new ArrayList<AreaGroup>();
        for (Set<Area> set : groups.sets()) {
            try {
                out.add(new AreaGroup(set));
            }
            catch (Ring.RingConstructionException e) {
                for (Area area : set) {
                    LOG.debug("Failed to create merged area for " + area + ".  This area might not be at fault; it might be one of the other areas in this list.");
                    out.add(new AreaGroup(Arrays.asList(area)));
                }
            }
        }
        return out;
    }

    private Ring toRing(Polygon polygon, HashMap<Coordinate, OSMNode> nodeMap) {
        ArrayList<OSMNode> shell = new ArrayList<OSMNode>();
        for (Coordinate coord : polygon.getExteriorRing().getCoordinates()) {
            OSMNode node = nodeMap.get(coord);
            if (node == null) {
                throw new Ring.RingConstructionException();
            }
            shell.add(node);
        }
        Ring ring = new Ring(shell);
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            LinearRing interior = polygon.getInteriorRingN(i);
            ArrayList<OSMNode> hole = new ArrayList<OSMNode>();
            for (Coordinate coord : interior.getCoordinates()) {
                OSMNode node = nodeMap.get(coord);
                if (node == null) {
                    throw new Ring.RingConstructionException();
                }
                hole.add(node);
            }
            ring.addHole(new Ring(hole));
        }
        return ring;
    }

    public OSMWithTags getSomeOSMObject() {
        return this.areas.iterator().next().parent;
    }
}

