/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.ned;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class VerticalDatum {
    double lowerLeftLatitude;
    double lowerLeftLongitude;
    double deltaLatitude;
    double deltaLongitude;
    float[][] datum;

    public VerticalDatum(double lowerLeftLongitude, double lowerLeftLatitude, double width, double height, float[][] datum) {
        this.lowerLeftLongitude = lowerLeftLongitude;
        this.lowerLeftLatitude = lowerLeftLatitude;
        this.deltaLongitude = width;
        this.deltaLatitude = height;
        this.datum = datum;
    }

    double interpolatedHeight(double longitude, double latitude) {
        double lowerLeftAdjusted = this.lowerLeftLongitude;
        if (this.lowerLeftLongitude + this.deltaLongitude > 180.0 && longitude < this.lowerLeftLongitude) {
            lowerLeftAdjusted -= 360.0;
            if (longitude < this.lowerLeftLongitude) {
                throw new RuntimeException("longitude out of range");
            }
        }
        if (longitude > lowerLeftAdjusted + this.deltaLongitude || longitude < lowerLeftAdjusted) {
            throw new RuntimeException("longitude out of range");
        }
        if (latitude < this.lowerLeftLatitude || latitude > this.lowerLeftLatitude + this.deltaLatitude) {
            throw new RuntimeException("latitude out of range");
        }
        double longitudeNormalized = (longitude - lowerLeftAdjusted) / this.deltaLongitude;
        double latitudeNormalized = (latitude - this.lowerLeftLatitude) / this.deltaLatitude;
        int rows = this.datum.length;
        int columns = this.datum[0].length;
        int x1 = (int)Math.floor(longitudeNormalized * (double)columns);
        int y1 = (int)Math.floor(latitudeNormalized * (double)rows);
        double gridXFraction = longitudeNormalized * (double)columns - (double)x1;
        double gridYFraction = latitudeNormalized * (double)rows - (double)y1;
        return (double)this.datum[y1][x1] * gridXFraction * gridYFraction + (double)this.datum[y1][x1 + 1] * (1.0 - gridXFraction) * gridYFraction + (double)this.datum[y1 + 1][x1] * gridXFraction * (1.0 - gridYFraction) + (double)this.datum[y1 + 1][x1 + 1] * (1.0 - gridXFraction) * (1.0 - gridYFraction);
    }

    boolean covers(double longitude, double latitude) {
        double lowerLeftAdjusted = this.lowerLeftLongitude;
        if (this.lowerLeftLongitude + this.deltaLongitude > 180.0 && longitude < this.lowerLeftLongitude) {
            lowerLeftAdjusted -= 360.0;
            if (longitude < this.lowerLeftLongitude) {
                return false;
            }
        }
        if (longitude > lowerLeftAdjusted + this.deltaLongitude || longitude < lowerLeftAdjusted) {
            return false;
        }
        return !(latitude < this.lowerLeftLatitude) && !(latitude > this.lowerLeftLatitude + this.deltaLatitude);
    }

    public static VerticalDatum fromGTX(InputStream inputStream) throws IOException {
        DataInputStream stream = new DataInputStream(new BufferedInputStream(inputStream));
        double lowerLeftLatitude = stream.readDouble();
        double lowerLeftLongitude = stream.readDouble();
        if (lowerLeftLongitude > 180.0) {
            lowerLeftLongitude -= 360.0;
        }
        double deltaLatitude = stream.readDouble();
        double deltaLongitude = stream.readDouble();
        int nRows = stream.readInt();
        int nColumns = stream.readInt();
        float[][] data = new float[nRows][nColumns];
        for (int y = 0; y < nRows; ++y) {
            for (int x = 0; x < nColumns; ++x) {
                data[y][x] = stream.readFloat();
            }
        }
        return new VerticalDatum(lowerLeftLongitude, lowerLeftLatitude, deltaLatitude * (double)nColumns, deltaLongitude * (double)nRows, data);
    }
}

