/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.ned;

import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBilinear;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.Interpolator2D;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.util.factory.Hints;
import org.opentripplanner.datastore.DataSource;
import org.opentripplanner.datastore.FileType;
import org.opentripplanner.datastore.file.FileDataSource;
import org.opentripplanner.graph_builder.services.ned.ElevationGridCoverageFactory;
import org.opentripplanner.routing.graph.Graph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeotiffGridCoverageFactoryImpl
implements ElevationGridCoverageFactory {
    private static final Logger LOG = LoggerFactory.getLogger(GeotiffGridCoverageFactoryImpl.class);
    private final DataSource input;
    private GridCoverage2D coverage;

    public GeotiffGridCoverageFactoryImpl(DataSource input) {
        this.input = input;
    }

    public GeotiffGridCoverageFactoryImpl(File path) {
        this(new FileDataSource(path, FileType.DEM));
    }

    public GridCoverage2D getGridCoverage() {
        return Interpolator2D.create((GridCoverage2D)this.getUninterpolatedGridCoverage(), (Interpolation)new InterpolationBilinear());
    }

    public GridCoverage2D getUninterpolatedGridCoverage() {
        if (this.coverage == null) {
            try {
                Hints forceLongLat = new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE);
                GeoTiffFormat format = new GeoTiffFormat();
                GeoTiffReader reader = format.getReader(this.getSource(), forceLongLat);
                this.coverage = reader.read(null);
                LOG.debug("Elevation model CRS is: {}", (Object)this.coverage.getCoordinateReferenceSystem2D());
            }
            catch (IOException e) {
                throw new RuntimeException("Error getting coverage automatically. ", e);
            }
        }
        return this.coverage;
    }

    private Object getSource() {
        return this.input.asInputStream();
    }

    @Override
    public void checkInputs() {
        if (!this.input.exists()) {
            throw new RuntimeException("Can't read elevation path: " + this.input.path());
        }
    }

    @Override
    public void fetchData(Graph graph) {
    }
}

