/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.ned;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.geotools.geometry.DirectPosition2D;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.PointOutsideCoverageException;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.TransformException;
import org.opentripplanner.common.geometry.GeometryUtils;
import org.opentripplanner.common.geometry.PackedCoordinateSequence;
import org.opentripplanner.common.geometry.SphericalDistanceLibrary;
import org.opentripplanner.common.pqueue.BinHeap;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.ElevationFlattened;
import org.opentripplanner.graph_builder.issues.ElevationPropagationLimit;
import org.opentripplanner.graph_builder.issues.Graphwide;
import org.opentripplanner.graph_builder.module.extra_elevation_data.ElevationPoint;
import org.opentripplanner.graph_builder.services.GraphBuilderModule;
import org.opentripplanner.graph_builder.services.ned.ElevationGridCoverageFactory;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.edgetype.StreetWithElevationEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.util.ElevationUtils;
import org.opentripplanner.util.PolylineEncoder;
import org.opentripplanner.util.ProgressTracker;
import org.opentripplanner.util.logging.ThrottleLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElevationModule
implements GraphBuilderModule {
    private static final Logger LOG = LoggerFactory.getLogger(ElevationModule.class);
    private static final Logger ELEVATION_EDGE_ERROR_LOG = ThrottleLogger.throttle(LOG);
    private final ElevationGridCoverageFactory gridCoverageFactory;
    private final boolean readCachedElevations;
    private final boolean writeCachedElevations;
    private final File cachedElevationsFile;
    private final boolean includeEllipsoidToGeoidDifference;
    private final boolean multiThreadElevationCalculations;
    private DataImportIssueStore issueStore;
    private HashMap<String, PackedCoordinateSequence> cachedElevations;
    private final AtomicInteger nPointsEvaluated = new AtomicInteger(0);
    private final AtomicInteger nPointsOutsideDEM = new AtomicInteger(0);
    private Coordinate examplarCoordinate;
    private final double distanceBetweenSamplesM;
    private final double elevationUnitMultiplier;
    private Graph graph;
    private final ConcurrentHashMap<Integer, Double> geoidDifferenceCache = new ConcurrentHashMap();
    private Coverage singleThreadedCoverageInterpolator;
    private final ThreadLocal<Coverage> coverageInterpolatorThreadLocal = new ThreadLocal();

    public ElevationModule(ElevationGridCoverageFactory factory) {
        this(factory, null, false, false, 1.0, 10.0, true, false);
    }

    public ElevationModule(ElevationGridCoverageFactory factory, File cachedElevationsFile, boolean readCachedElevations, boolean writeCachedElevations, double elevationUnitMultiplier, double distanceBetweenSamplesM, boolean includeEllipsoidToGeoidDifference, boolean multiThreadElevationCalculations) {
        this.gridCoverageFactory = factory;
        this.cachedElevationsFile = cachedElevationsFile;
        this.readCachedElevations = readCachedElevations;
        this.writeCachedElevations = writeCachedElevations;
        this.elevationUnitMultiplier = elevationUnitMultiplier;
        this.includeEllipsoidToGeoidDifference = includeEllipsoidToGeoidDifference;
        this.multiThreadElevationCalculations = multiThreadElevationCalculations;
        this.distanceBetweenSamplesM = distanceBetweenSamplesM;
    }

    public static int fromConfig(JsonNode elevationModuleParallelism) {
        int maxProcessors = Runtime.getRuntime().availableProcessors();
        int minimumProcessors = 1;
        return Math.max(minimumProcessors, Math.min(elevationModuleParallelism.asInt(minimumProcessors), maxProcessors));
    }

    @Override
    public void buildGraph(Graph graph, HashMap<Class<?>, Object> extra, DataImportIssueStore issueStore) {
        double d;
        this.issueStore = issueStore;
        this.graph = graph;
        this.gridCoverageFactory.fetchData(graph);
        graph.setDistanceBetweenElevationSamples(this.distanceBetweenSamplesM);
        if (this.readCachedElevations) {
            try {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(this.cachedElevationsFile));
                this.cachedElevations = (HashMap)in.readObject();
                LOG.info("Cached elevation data loaded into memory!");
            }
            catch (IOException | ClassNotFoundException e) {
                issueStore.add(new Graphwide(String.format("Cached elevations file could not be read in due to error: %s!", e.getMessage())));
            }
        }
        LOG.info("Setting street elevation profiles from digital elevation model...");
        LinkedList<StreetWithElevationEdge> streetsWithElevationEdges = new LinkedList<StreetWithElevationEdge>();
        for (Vertex gv : graph.getVertices()) {
            for (Edge edge : gv.getOutgoing()) {
                if (!(edge instanceof StreetWithElevationEdge)) continue;
                if (this.multiThreadElevationCalculations && this.examplarCoordinate == null) {
                    this.examplarCoordinate = edge.getGeometry().getCoordinates()[0];
                }
                streetsWithElevationEdges.add((StreetWithElevationEdge)edge);
            }
        }
        int totalElevationEdges = streetsWithElevationEdges.size();
        ProgressTracker progress = ProgressTracker.track("Set elevation", 25000, totalElevationEdges);
        if (this.multiThreadElevationCalculations) {
            streetsWithElevationEdges.parallelStream().forEach(ee -> this.processEdgeWithProgress((StreetWithElevationEdge)ee, progress));
        } else {
            for (StreetWithElevationEdge streetWithElevationEdge : streetsWithElevationEdges) {
                this.processEdgeWithProgress(streetWithElevationEdge, progress);
            }
        }
        int nPoints = this.nPointsEvaluated.get();
        if (nPoints > 0 && (d = (double)this.nPointsOutsideDEM.get() / (double)nPoints * 100.0) > 50.0) {
            issueStore.add(new Graphwide(String.format("Fetching elevation failed at %d/%d points (%.1f%%)", this.nPointsOutsideDEM.get(), nPoints, d)));
            LOG.warn("Elevation is missing at a large number of points. DEM may be for the wrong region. If it is unprojected, perhaps the axes are not in (longitude, latitude) order.");
        }
        LinkedList<StreetEdge> linkedList = new LinkedList<StreetEdge>();
        for (StreetWithElevationEdge streetWithElevationEdge : streetsWithElevationEdges) {
            if (!streetWithElevationEdge.hasPackedElevationProfile() || streetWithElevationEdge.isElevationFlattened()) continue;
            linkedList.add(streetWithElevationEdge);
        }
        if (this.writeCachedElevations) {
            HashMap<String, PackedCoordinateSequence> newCachedElevations = new HashMap<String, PackedCoordinateSequence>();
            for (StreetEdge streetEdge : linkedList) {
                newCachedElevations.put(PolylineEncoder.createEncodings((Geometry)streetEdge.getGeometry()).getPoints(), streetEdge.getElevationProfile());
            }
            try {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.cachedElevationsFile)));
                objectOutputStream.writeObject(newCachedElevations);
                objectOutputStream.close();
            }
            catch (IOException iOException) {
                LOG.error(iOException.getMessage());
                issueStore.add(new Graphwide("Failed to write cached elevation file!"));
            }
        }
        HashMap extraElevation = (HashMap)extra.get(ElevationPoint.class);
        this.assignMissingElevations(graph, linkedList, extraElevation);
    }

    private void assignMissingElevations(Graph graph, List<StreetEdge> edgesWithElevation, HashMap<Vertex, Double> knownElevations) {
        LOG.debug("Assigning missing elevations");
        BinHeap<ElevationRepairState> pq = new BinHeap<ElevationRepairState>();
        HashMap<Vertex, Double> elevations = knownElevations != null ? (HashMap<Vertex, Double>)knownElevations.clone() : new HashMap<Vertex, Double>();
        if (this.includeEllipsoidToGeoidDifference) {
            elevations.forEach((vertex, elevation) -> {
                try {
                    elevations.put((Vertex)vertex, elevation - this.getApproximateEllipsoidToGeoidDifference(vertex.getY(), vertex.getX()));
                }
                catch (TransformException e) {
                    LOG.error("Error processing elevation for known elevation at vertex: {} due to error: {}", vertex, (Object)e);
                }
            });
        }
        HashSet<Vertex> closed = new HashSet<Vertex>();
        for (StreetEdge e : edgesWithElevation) {
            ElevationRepairState state;
            PackedCoordinateSequence profile = e.getElevationProfile();
            if (!elevations.containsKey(e.getFromVertex())) {
                double firstElevation = profile.getOrdinate(0, 1);
                state = new ElevationRepairState(null, null, e.getFromVertex(), 0.0, firstElevation);
                pq.insert(state, 0.0);
                elevations.put(e.getFromVertex(), firstElevation);
            }
            if (elevations.containsKey(e.getToVertex())) continue;
            double lastElevation = profile.getOrdinate(profile.size() - 1, 1);
            state = new ElevationRepairState(null, null, e.getToVertex(), 0.0, lastElevation);
            pq.insert(state, 0.0);
            elevations.put(e.getToVertex(), lastElevation);
        }
        block1: while (!pq.empty()) {
            Double elevation2;
            StreetEdge edge;
            ElevationRepairState state = (ElevationRepairState)pq.extract_min();
            if (closed.contains(state.vertex)) continue;
            closed.add(state.vertex);
            ElevationRepairState curState = state;
            Vertex initialVertex = null;
            while (curState != null) {
                initialVertex = curState.vertex;
                curState = curState.backState;
            }
            double bestDistance = Double.MAX_VALUE;
            double bestElevation = 0.0;
            for (Edge e : state.vertex.getOutgoing()) {
                if (!(e instanceof StreetEdge)) continue;
                edge = (StreetEdge)e;
                Vertex tov = e.getToVertex();
                if (tov == initialVertex) continue;
                elevation2 = (Double)elevations.get(tov);
                if (elevation2 != null) {
                    double distance = e.getDistanceMeters();
                    if (!(distance < bestDistance)) continue;
                    bestDistance = distance;
                    bestElevation = elevation2;
                    continue;
                }
                ElevationRepairState newState = new ElevationRepairState(edge, state, tov, e.getDistanceMeters() + state.distance, state.initialElevation);
                pq.insert(newState, e.getDistanceMeters() + state.distance);
            }
            for (Edge e : state.vertex.getIncoming()) {
                if (!(e instanceof StreetEdge)) continue;
                edge = (StreetEdge)e;
                Vertex fromv = e.getFromVertex();
                if (fromv == initialVertex) continue;
                elevation2 = (Double)elevations.get(fromv);
                if (elevation2 != null) {
                    double distance = e.getDistanceMeters();
                    if (!(distance < bestDistance)) continue;
                    bestDistance = distance;
                    bestElevation = elevation2;
                    continue;
                }
                ElevationRepairState newState = new ElevationRepairState(edge, state, fromv, e.getDistanceMeters() + state.distance, state.initialElevation);
                pq.insert(newState, e.getDistanceMeters() + state.distance);
            }
            if (bestDistance == Double.MAX_VALUE && state.distance > 2000.0) {
                this.issueStore.add(new ElevationPropagationLimit(state.vertex));
                bestDistance = state.distance;
                bestElevation = state.initialElevation;
            }
            if (bestDistance == Double.MAX_VALUE) continue;
            double totalDistance = bestDistance + state.distance;
            do {
                if (totalDistance == 0.0) {
                    elevations.put(state.vertex, bestElevation);
                } else {
                    double elevation3 = (bestElevation * state.distance + state.initialElevation * bestDistance) / totalDistance;
                    elevations.put(state.vertex, elevation3);
                }
                if (state.backState == null) continue block1;
                bestDistance += state.backEdge.getDistanceMeters();
                state = state.backState;
            } while (!elevations.containsKey(state.vertex));
        }
        for (Vertex v : graph.getVertices()) {
            Double fromElevation = (Double)elevations.get(v);
            for (Edge e : v.getOutgoing()) {
                if (!(e instanceof StreetWithElevationEdge)) continue;
                StreetWithElevationEdge edge = (StreetWithElevationEdge)e;
                Double toElevation = (Double)elevations.get(edge.getToVertex());
                if (fromElevation == null || toElevation == null) {
                    if (edge.isElevationFlattened() || edge.isSlopeOverride()) continue;
                    LOG.warn("Unexpectedly missing elevation for edge " + edge);
                    continue;
                }
                if (edge.getElevationProfile() != null && edge.getElevationProfile().size() > 2) continue;
                Coordinate[] coords = new Coordinate[]{new Coordinate(0.0, fromElevation.doubleValue()), new Coordinate(edge.getDistanceMeters(), toElevation.doubleValue())};
                PackedCoordinateSequence.Double profile = new PackedCoordinateSequence.Double(coords);
                if (!edge.setElevationProfile(profile, true)) continue;
                this.issueStore.add(new ElevationFlattened(edge));
            }
        }
    }

    private void processEdgeWithProgress(StreetWithElevationEdge ee, ProgressTracker progress) {
        this.processEdge(ee);
        progress.step(m -> LOG.info(m));
    }

    private void processEdge(StreetWithElevationEdge ee) {
        PackedCoordinateSequence coordinateSequence;
        if (ee.hasPackedElevationProfile()) {
            return;
        }
        LineString edgeGeometry = ee.getGeometry();
        if (this.cachedElevations != null && (coordinateSequence = this.cachedElevations.get(PolylineEncoder.createEncodings((Geometry)edgeGeometry).getPoints())) != null) {
            this.setEdgeElevationProfile(ee, coordinateSequence, this.graph);
            return;
        }
        Coverage coverage = this.getThreadSpecificCoverageInterpolator();
        try {
            Coordinate[] coords = edgeGeometry.getCoordinates();
            LinkedList<Coordinate> coordList = new LinkedList<Coordinate>();
            coordList.add(new Coordinate(0.0, this.getElevation(coverage, coords[0])));
            double edgeLenM = 0.0;
            double sampleDistance = this.distanceBetweenSamplesM;
            double previousDistance = 0.0;
            double x1 = coords[0].x;
            double y1 = coords[0].y;
            for (int i = 0; i < coords.length - 1; ++i) {
                double x2 = coords[i + 1].x;
                double y2 = coords[i + 1].y;
                double curSegmentDistance = SphericalDistanceLibrary.distance(y1, x1, y2, x2);
                edgeLenM += curSegmentDistance;
                while (edgeLenM > sampleDistance) {
                    double pctAlongSeg = (sampleDistance - previousDistance) / curSegmentDistance;
                    coordList.add(new Coordinate(sampleDistance, this.getElevation(coverage, new Coordinate(x1 + pctAlongSeg * (x2 - x1), y1 + pctAlongSeg * (y2 - y1)))));
                    sampleDistance += this.distanceBetweenSamplesM;
                }
                previousDistance = edgeLenM;
                x1 = x2;
                y1 = y2;
            }
            if (edgeLenM - ((Coordinate)coordList.get((int)(coordList.size() - 1))).x < this.distanceBetweenSamplesM / 2.0) {
                coordList.remove(coordList.size() - 1);
            }
            coordList.add(new Coordinate(edgeLenM, this.getElevation(coverage, coords[coords.length - 1])));
            Coordinate[] coordArr = new Coordinate[coordList.size()];
            PackedCoordinateSequence.Double elevPCS = new PackedCoordinateSequence.Double(coordList.toArray(coordArr));
            this.setEdgeElevationProfile(ee, elevPCS, this.graph);
        }
        catch (ElevationLookupException e) {
            ELEVATION_EDGE_ERROR_LOG.warn("Error processing elevation for edge: {} due to error: {}", (Object)ee, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Coverage getThreadSpecificCoverageInterpolator() {
        if (this.multiThreadElevationCalculations) {
            Coverage coverage = this.coverageInterpolatorThreadLocal.get();
            if (coverage == null) {
                ElevationGridCoverageFactory elevationGridCoverageFactory = this.gridCoverageFactory;
                synchronized (elevationGridCoverageFactory) {
                    coverage = this.gridCoverageFactory.getGridCoverage();
                    try {
                        this.getElevation(coverage, this.examplarCoordinate);
                    }
                    catch (ElevationLookupException e) {
                        ELEVATION_EDGE_ERROR_LOG.warn("Error processing elevation for coordinate: {} due to error: {}", (Object)this.examplarCoordinate, (Object)e);
                    }
                    this.coverageInterpolatorThreadLocal.set(coverage);
                }
            }
            return coverage;
        }
        if (this.singleThreadedCoverageInterpolator == null) {
            this.singleThreadedCoverageInterpolator = this.gridCoverageFactory.getGridCoverage();
        }
        return this.singleThreadedCoverageInterpolator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEdgeElevationProfile(StreetWithElevationEdge ee, PackedCoordinateSequence elevPCS, Graph graph) {
        if (ee.setElevationProfile(elevPCS, false)) {
            Graph graph2 = graph;
            synchronized (graph2) {
                this.issueStore.add(new ElevationFlattened(ee));
            }
        }
    }

    private double getElevation(Coverage coverage, Coordinate c) throws ElevationLookupException {
        try {
            return this.getElevation(coverage, c.x, c.y);
        }
        catch (ArrayIndexOutOfBoundsException | PointOutsideCoverageException | TransformException e) {
            throw new ElevationLookupException((Exception)e);
        }
    }

    private double getElevation(Coverage coverage, double x, double y) throws PointOutsideCoverageException, TransformException {
        double[] values = new double[1];
        try {
            coverage.evaluate((DirectPosition)new DirectPosition2D(GeometryUtils.WGS84_XY, x, y), values);
        }
        catch (PointOutsideCoverageException e) {
            this.nPointsOutsideDEM.incrementAndGet();
            throw e;
        }
        this.nPointsEvaluated.incrementAndGet();
        return values[0] * this.elevationUnitMultiplier - (this.includeEllipsoidToGeoidDifference ? this.getApproximateEllipsoidToGeoidDifference(y, x) : 0.0);
    }

    private double getApproximateEllipsoidToGeoidDifference(double y, double x) throws TransformException {
        int geoidDifferenceCoordinateValueMultiplier = 100;
        int xVal = (int)Math.round(x * (double)geoidDifferenceCoordinateValueMultiplier);
        int yVal = (int)Math.round(y * (double)geoidDifferenceCoordinateValueMultiplier);
        int hash = yVal * 104729 + xVal;
        Double difference = this.geoidDifferenceCache.get(hash);
        if (difference == null) {
            difference = ElevationUtils.computeEllipsoidToGeoidDifference((double)yVal / (1.0 * (double)geoidDifferenceCoordinateValueMultiplier), (double)xVal / (1.0 * (double)geoidDifferenceCoordinateValueMultiplier));
            this.geoidDifferenceCache.put(hash, difference);
        }
        return difference;
    }

    @Override
    public void checkInputs() {
        this.gridCoverageFactory.checkInputs();
        if (this.readCachedElevations) {
            if (Files.exists(this.cachedElevationsFile.toPath(), new LinkOption[0])) {
                LOG.info("Cached elevations file found!");
            } else {
                LOG.warn("No cached elevations file found at {} or read access not allowed! Unable to load in cached elevations. This could take a while...", (Object)this.cachedElevationsFile.toPath().toAbsolutePath());
            }
        } else {
            LOG.warn("Not using cached elevations! This could take a while...");
        }
    }

    class ElevationLookupException
    extends Exception {
        public ElevationLookupException(Exception e) {
            super(e);
        }
    }

    static class ElevationRepairState {
        public StreetEdge backEdge;
        public ElevationRepairState backState;
        public Vertex vertex;
        public double distance;
        public double initialElevation;

        public ElevationRepairState(StreetEdge backEdge, ElevationRepairState backState, Vertex vertex, double distance, double initialElevation) {
            this.backEdge = backEdge;
            this.backState = backState;
            this.vertex = vertex;
            this.distance = distance;
            this.initialElevation = initialElevation;
        }
    }
}

