/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.ned;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.ProviderCredentials;
import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.common.model.P2;
import org.opentripplanner.graph_builder.services.ned.NEDTileSource;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DegreeGridNEDTileSource
implements NEDTileSource {
    private static Logger log = LoggerFactory.getLogger(DegreeGridNEDTileSource.class);
    private Graph graph;
    private File cacheDirectory;
    public String awsAccessKey;
    public String awsSecretKey;
    public String awsBucketName;
    private List<File> nedTiles;

    @Override
    public List<File> getNEDTiles() {
        return this.nedTiles;
    }

    @Override
    public void fetchData(Graph graph, File cacheDirectory) {
        this.graph = graph;
        this.cacheDirectory = cacheDirectory;
        HashSet<P2<Integer>> tiles = new HashSet<P2<Integer>>();
        for (Vertex v : graph.getVertices()) {
            Coordinate coordinate = v.getCoordinate();
            tiles.add(new P2<Integer>((int)coordinate.x, (int)coordinate.y));
        }
        ArrayList<File> paths = new ArrayList<File>();
        for (P2 p2 : tiles) {
            int y;
            int x = (Integer)p2.first - 1;
            File tilePath = this.getPathToTile(x, y = (Integer)p2.second + 1);
            if (tilePath == null) continue;
            paths.add(tilePath);
        }
        if (paths.size() == 0) {
            throw new RuntimeException("No elevation tiles were able to be downloaded!");
        }
        this.nedTiles = paths;
    }

    private String formatLatLon(int x, int y) {
        String eastWest;
        String northSouth;
        if (y < 0) {
            northSouth = "s";
            y = -y;
        } else {
            northSouth = "n";
        }
        if (x < 0) {
            eastWest = "w";
            x = -x;
        } else {
            eastWest = "e";
        }
        return String.format("%s%d%s%03d", northSouth, y, eastWest, x);
    }

    private File getPathToTile(int x, int y) {
        File path = new File(this.cacheDirectory, this.formatLatLon(x, y) + ".tiff");
        if (path.exists()) {
            return path;
        }
        path.getParentFile().mkdirs();
        if (this.awsAccessKey == null || this.awsSecretKey == null) {
            throw new RuntimeException("Cannot download NED tiles from S3: awsAccessKey or awsSecretKey properties are not set");
        }
        log.info("Downloading NED degree tile " + path);
        AWSCredentials awsCredentials = new AWSCredentials(this.awsAccessKey, this.awsSecretKey);
        String key = this.formatLatLon(x, y) + ".tiff";
        try {
            int read;
            RestS3Service s3Service = new RestS3Service((ProviderCredentials)awsCredentials);
            S3Object object = s3Service.getObject(this.awsBucketName, key);
            InputStream istream = object.getDataInputStream();
            FileOutputStream ostream = new FileOutputStream(path);
            byte[] buffer = new byte[4096];
            while ((read = istream.read(buffer)) != -1) {
                ostream.write(buffer, 0, read);
            }
            ostream.close();
            istream.close();
        }
        catch (S3ServiceException e) {
            if (e.getS3ErrorCode().equals("NoSuchKey")) {
                log.error(String.format("Elevation tile %s missing from s3bucket. Proceeding without tile!", key));
                return null;
            }
            path.deleteOnExit();
            throw new RuntimeException(e);
        }
        catch (IOException | ServiceException e) {
            path.deleteOnExit();
            throw new RuntimeException(e);
        }
        return path;
    }
}

